/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.ChemicalTankContentsHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemBlockChemicalTank
extends ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>>
implements IItemSustainedInventory,
ISecurityItem {
    public ItemBlockChemicalTank(BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>> block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1));
    }

    @Override
    public ChemicalTankTier getTier() {
        return Attribute.getTier(this.func_179223_d(), ChemicalTankTier.class);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        ChemicalTankTier tier = this.getTier();
        StorageUtils.addStoredSubstance(stack, tooltip, tier == ChemicalTankTier.CREATIVE);
        if (tier == ChemicalTankTier.CREATIVE) {
            tooltip.add((ITextComponent)MekanismLang.CAPACITY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, MekanismLang.INFINITE));
        } else {
            tooltip.add((ITextComponent)MekanismLang.CAPACITY_MB.translateColored(EnumColor.INDIGO, EnumColor.GRAY, TextUtils.format(tier.getStorage())));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    public void addDetails(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        SecurityUtils.addSecurityTooltip(stack, tooltip);
        tooltip.add((ITextComponent)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))));
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        ChemicalTankTier tier;
        super.func_150895_a(group, items);
        if (this.func_194125_a(group) && (tier = Attribute.getTier(this.func_179223_d(), ChemicalTankTier.class)) == ChemicalTankTier.CREATIVE) {
            long capacity = tier.getStorage();
            this.fillItemGroup(MekanismConfig.general.prefilledGasTanks, MekanismAPI.gasRegistry(), items, capacity);
            this.fillItemGroup(MekanismConfig.general.prefilledInfusionTanks, MekanismAPI.infuseTypeRegistry(), items, capacity);
            this.fillItemGroup(MekanismConfig.general.prefilledPigmentTanks, MekanismAPI.pigmentRegistry(), items, capacity);
            this.fillItemGroup(MekanismConfig.general.prefilledSlurryTanks, MekanismAPI.slurryRegistry(), items, capacity);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>> void fillItemGroup(BooleanSupplier shouldAdd, IForgeRegistry<CHEMICAL> registry, @Nonnull NonNullList<ItemStack> items, long capacity) {
        if (shouldAdd.getAsBoolean()) {
            for (Chemical type : registry.getValues()) {
                if (type.isHidden()) continue;
                items.add((Object)ChemicalUtil.getFilledVariant(new ItemStack((IItemProvider)this), capacity, type));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ChemicalUtil.hasGas(stack) || ChemicalUtil.hasChemical(stack, s -> true, Capabilities.INFUSION_HANDLER_CAPABILITY) || ChemicalUtil.hasChemical(stack, s -> true, Capabilities.PIGMENT_HANDLER_CAPABILITY) || ChemicalUtil.hasChemical(stack, s -> true, Capabilities.SLURRY_HANDLER_CAPABILITY);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ChemicalUtil.getRGBDurabilityForDisplay(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, ChemicalTankContentsHandler.create(Attribute.getTier(this.func_179223_d(), ChemicalTankTier.class)));
    }
}

