/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation.capability;

import java.util.Random;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityCache;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.radiation.capability.IRadiationEntity;
import mekanism.common.network.PacketRadiationData;
import mekanism.common.registries.MekanismDamageSource;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class DefaultRadiationEntity
implements IRadiationEntity {
    private double radiation;
    private double clientSeverity = 0.0;

    @Override
    public double getRadiation() {
        return this.radiation;
    }

    @Override
    public void radiate(double magnitude) {
        this.radiation += magnitude;
    }

    @Override
    public void update(LivingEntity entity) {
        double chance;
        if (entity instanceof PlayerEntity && !MekanismUtils.isPlayingMode((PlayerEntity)entity)) {
            return;
        }
        Random rand = entity.field_70170_p.func_201674_k();
        double minSeverity = MekanismConfig.general.radiationNegativeEffectsMinSeverity.get();
        double severityScale = RadiationManager.RadiationScale.getScaledDoseSeverity(this.radiation);
        if (severityScale > (chance = minSeverity + rand.nextDouble() * (1.0 - minSeverity)) && rand.nextInt() % 2 == 0) {
            entity.func_70097_a((DamageSource)MekanismDamageSource.RADIATION, 1.0f);
        }
        if (entity instanceof PlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (this.clientSeverity != this.radiation) {
                this.clientSeverity = this.radiation;
                PacketRadiationData.sync(player);
            }
            if (severityScale > chance) {
                player.func_71024_bL().func_75113_a(1.0f);
            }
        }
    }

    @Override
    public void set(double magnitude) {
        this.radiation = magnitude;
    }

    @Override
    public void decay() {
        this.radiation = Math.max(1.0E-7, this.radiation * MekanismConfig.general.radiationTargetDecayRate.get());
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT ret = new CompoundNBT();
        ret.func_74780_a("radiation", this.radiation);
        return ret;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.radiation = nbt.func_74769_h("radiation");
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IRadiationEntity.class, (Capability.IStorage)new Capability.IStorage<IRadiationEntity>(){

            public CompoundNBT writeNBT(Capability<IRadiationEntity> capability, IRadiationEntity instance, Direction side) {
                return (CompoundNBT)instance.serializeNBT();
            }

            public void readNBT(Capability<IRadiationEntity> capability, IRadiationEntity instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.deserializeNBT((INBT)((CompoundNBT)nbt));
                }
            }
        }, DefaultRadiationEntity::new);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        public static final ResourceLocation NAME = Mekanism.rl("radiation");
        private final IRadiationEntity defaultImpl = new DefaultRadiationEntity();
        private final CapabilityCache capabilityCache = new CapabilityCache();

        public Provider() {
            this.capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.RADIATION_ENTITY_CAPABILITY, this.defaultImpl));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction side) {
            return this.capabilityCache.getCapability(capability, side);
        }

        public void invalidate() {
            this.capabilityCache.invalidate(Capabilities.RADIATION_ENTITY_CAPABILITY, null);
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.defaultImpl.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.defaultImpl.deserializeNBT((INBT)nbt);
        }
    }
}

