/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.container.property.list;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.container.property.PropertyData;
import mekanism.common.network.container.property.PropertyType;
import mekanism.common.network.container.property.list.FilterListPropertyData;
import mekanism.common.network.container.property.list.FrequencyListPropertyData;
import mekanism.common.network.container.property.list.ListType;
import mekanism.common.network.container.property.list.StringListPropertyData;
import net.minecraft.network.PacketBuffer;

public abstract class ListPropertyData<TYPE>
extends PropertyData {
    @Nonnull
    protected final List<TYPE> values;
    private final ListType listType;

    public ListPropertyData(short property, ListType listType, @Nonnull List<TYPE> values) {
        super(PropertyType.LIST, property);
        this.listType = listType;
        this.values = values;
    }

    public static <TYPE> ListPropertyData<TYPE> readList(short property, PacketBuffer buffer) {
        ListType listType = (ListType)buffer.func_179257_a(ListType.class);
        int elements = buffer.func_150792_a();
        switch (listType) {
            case STRING: {
                return StringListPropertyData.read(property, elements, buffer);
            }
            case FILTER: {
                return FilterListPropertyData.read(property, elements, buffer);
            }
            case FREQUENCY: {
                return FrequencyListPropertyData.read(property, elements, buffer);
            }
        }
        Mekanism.logger.error("Unrecognized list type received: {}", (Object)listType);
        return null;
    }

    @Override
    public void handleWindowProperty(MekanismContainer container) {
        container.handleWindowProperty(this.getProperty(), this.values);
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        super.writeToPacket(buffer);
        buffer.func_179249_a((Enum)this.listType);
        buffer.func_150787_b(this.values.size());
        this.writeListElements(buffer);
    }

    protected abstract void writeListElements(PacketBuffer var1);
}

