/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.chemical.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FluidSlurryToSlurryRecipeSerializer<RECIPE extends FluidSlurryToSlurryRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public FluidSlurryToSlurryRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray fluidInput = JSONUtils.func_151202_d((JsonObject)json, (String)"fluidInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"fluidInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"fluidInput");
        FluidStackIngredient fluidIngredient = FluidStackIngredient.deserialize((JsonElement)fluidInput);
        JsonArray slurryInput = JSONUtils.func_151202_d((JsonObject)json, (String)"slurryInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"slurryInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"slurryInput");
        SlurryStackIngredient slurryIngredient = SlurryStackIngredient.deserialize((JsonElement)slurryInput);
        SlurryStack output = SerializerHelper.getSlurryStack(json, "output");
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, fluidIngredient, slurryIngredient, output);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            FluidStackIngredient fluidInput = FluidStackIngredient.read(buffer);
            SlurryStackIngredient slurryInput = SlurryStackIngredient.read(buffer);
            SlurryStack output = SlurryStack.readFromPacket(buffer);
            return this.factory.create(recipeId, fluidInput, slurryInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading fluid slurry to slurry recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            ((FluidChemicalToChemicalRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing fluid slurry to slurry recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends FluidSlurryToSlurryRecipe> {
        public RECIPE create(ResourceLocation var1, FluidStackIngredient var2, SlurryStackIngredient var3, SlurryStack var4);
    }
}

