/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ElectrolysisCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.ElectrolyticSeparatorEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityElectrolyticSeparator
extends TileEntityRecipeMachine<ElectrolysisRecipe>
implements IHasGasMode {
    public BasicFluidTank fluidTank;
    private static final long MAX_GAS = 2400L;
    public IGasTank leftTank;
    public IGasTank rightTank;
    public TileEntityChemicalTank.GasMode dumpLeft = TileEntityChemicalTank.GasMode.IDLE;
    public TileEntityChemicalTank.GasMode dumpRight = TileEntityChemicalTank.GasMode.IDLE;
    public FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private final IOutputHandler<@NonNull Pair<GasStack, GasStack>> outputHandler;
    private final IInputHandler<@NonNull FluidStack> inputHandler;
    private ElectrolyticSeparatorEnergyContainer energyContainer;
    private FluidInventorySlot fluidSlot;
    private GasInventorySlot leftOutputSlot;
    private GasInventorySlot rightOutputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityElectrolyticSeparator() {
        super(MekanismBlocks.ELECTROLYTIC_SEPARATOR);
        ConfigInfo gasConfig;
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.FLUID, TransmissionType.ENERGY);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, new InventorySlotInfo(true, true, this.fluidSlot));
            itemConfig.addSlotInfo(DataType.OUTPUT_1, new InventorySlotInfo(true, true, this.leftOutputSlot));
            itemConfig.addSlotInfo(DataType.OUTPUT_2, new InventorySlotInfo(true, true, this.rightOutputSlot));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, new InventorySlotInfo(true, true, this.fluidSlot, this.leftOutputSlot, this.rightOutputSlot));
            itemConfig.addSlotInfo(DataType.ENERGY, new InventorySlotInfo(true, true, this.energySlot));
            itemConfig.setDataType(DataType.INPUT, RelativeSide.FRONT);
            itemConfig.setDataType(DataType.OUTPUT_1, RelativeSide.LEFT);
            itemConfig.setDataType(DataType.OUTPUT_2, RelativeSide.RIGHT);
            itemConfig.setDataType(DataType.ENERGY, RelativeSide.BACK);
        }
        if ((gasConfig = this.configComponent.getConfig(TransmissionType.GAS)) != null) {
            gasConfig.addSlotInfo(DataType.OUTPUT_1, new ChemicalSlotInfo.GasSlotInfo(false, true, this.leftTank));
            gasConfig.addSlotInfo(DataType.OUTPUT_2, new ChemicalSlotInfo.GasSlotInfo(false, true, this.rightTank));
            gasConfig.setDataType(DataType.OUTPUT_1, RelativeSide.LEFT);
            gasConfig.setDataType(DataType.OUTPUT_2, RelativeSide.RIGHT);
            gasConfig.setEjecting(true);
        }
        this.configComponent.setupInputConfig(TransmissionType.FLUID, this.fluidTank);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
        this.inputHandler = InputHelper.getInputHandler(this.fluidTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.leftTank, this.rightTank);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.fluidTank = BasicFluidTank.input(24000, fluid -> this.containsRecipe(recipe -> recipe.getInput().testType(fluid)), this);
        builder.addTank(this.fluidTank);
        return builder.build();
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.leftTank = ChemicalTankBuilder.GAS.output(2400L, this);
        builder.addTank(this.leftTank);
        this.rightTank = ChemicalTankBuilder.GAS.output(2400L, this);
        builder.addTank(this.rightTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = ElectrolyticSeparatorEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.fluidSlot = FluidInventorySlot.fill(this.fluidTank, this, 26, 35);
        builder.addSlot(this.fluidSlot);
        this.leftOutputSlot = GasInventorySlot.drain(this.leftTank, this, 59, 52);
        builder.addSlot(this.leftOutputSlot);
        this.rightOutputSlot = GasInventorySlot.drain(this.rightTank, this, 101, 52);
        builder.addSlot(this.rightOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityElectrolyticSeparator)this).func_145831_w(), this, 143, 35);
        builder.addSlot(this.energySlot);
        this.fluidSlot.setSlotType(ContainerSlotType.INPUT);
        this.leftOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.rightOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.fluidSlot.fillTank();
        this.leftOutputSlot.drainTank();
        this.rightOutputSlot.drainTank();
        FloatingLong prev = this.energyContainer.getEnergy().copyAsConst();
        CachedRecipe oldCache = this.cachedRecipe;
        this.cachedRecipe = this.getUpdatedCache(0);
        if (oldCache != this.cachedRecipe) {
            this.energyContainer.updateEnergyPerTick();
        }
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        this.clientEnergyUsed = prev.subtract(this.energyContainer.getEnergy());
        long dumpAmount = 8L * (long)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        this.handleTank(this.leftTank, false, this.dumpLeft, this.getLeftSide(), dumpAmount);
        this.handleTank(this.rightTank, true, this.dumpRight, this.getRightSide(), dumpAmount);
    }

    private void handleTank(IGasTank tank, boolean right, TileEntityChemicalTank.GasMode mode, Direction side, long dumpAmount) {
        if (!tank.isEmpty()) {
            if (mode == TileEntityChemicalTank.GasMode.DUMPING) {
                tank.shrinkStack(dumpAmount, Action.EXECUTE);
            } else {
                long output;
                long needed;
                ConfigInfo config = this.configComponent.getConfig(TransmissionType.GAS);
                if (config != null && config.isEjecting()) {
                    ChemicalUtil.emit(config.getSidesForOutput(right ? DataType.OUTPUT_2 : DataType.OUTPUT_1), tank, this, MekanismConfig.general.chemicalAutoEjectRate.get());
                }
                if (mode == TileEntityChemicalTank.GasMode.DUMPING_EXCESS && (needed = tank.getNeeded()) < (output = MekanismConfig.general.chemicalAutoEjectRate.get())) {
                    tank.shrinkStack(output - needed, Action.EXECUTE);
                }
            }
        }
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ElectrolysisRecipe> getRecipeType() {
        return MekanismRecipeType.SEPARATING;
    }

    @Override
    @Nullable
    public ElectrolysisRecipe getRecipe(int cacheIndex) {
        FluidStack fluid = this.inputHandler.getInput();
        if (fluid.isEmpty()) {
            return null;
        }
        return (ElectrolysisRecipe)this.findFirstRecipe(recipe -> recipe.test(fluid));
    }

    @Override
    @Nullable
    public CachedRecipe<ElectrolysisRecipe> createNewCachedRecipe(@Nonnull ElectrolysisRecipe recipe, int cacheIndex) {
        return new ElectrolysisCachedRecipe(recipe, this.inputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setOnFinish(() -> this.markDirty(false)).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), currentMax);
        });
    }

    public ElectrolyticSeparatorEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumpLeft = (TileEntityChemicalTank.GasMode)this.dumpLeft.getNext();
            this.markDirty(false);
        } else if (tank == 1) {
            this.dumpRight = (TileEntityChemicalTank.GasMode)this.dumpRight.getNext();
            this.markDirty(false);
        }
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "dumpLeft", TileEntityChemicalTank.GasMode::byIndexStatic, mode -> {
            this.dumpLeft = mode;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "dumpRight", TileEntityChemicalTank.GasMode::byIndexStatic, mode -> {
            this.dumpRight = mode;
        });
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("dumpLeft", this.dumpLeft.ordinal());
        nbtTags.func_74768_a("dumpRight", this.dumpRight.ordinal());
        return nbtTags;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableEnum.create(TileEntityChemicalTank.GasMode::byIndexStatic, TileEntityChemicalTank.GasMode.IDLE, () -> this.dumpLeft, value -> {
            this.dumpLeft = value;
        }));
        container.track(SyncableEnum.create(TileEntityChemicalTank.GasMode::byIndexStatic, TileEntityChemicalTank.GasMode.IDLE, () -> this.dumpRight, value -> {
            this.dumpRight = value;
        }));
        container.track(SyncableFloatingLong.create(() -> this.clientEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }
}

