/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IConfigCardAccess;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.content.assemblicator.RecipeFormula;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FormulaInventorySlot;
import mekanism.common.inventory.slot.FormulaicCraftingSlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityFormulaicAssemblicator
extends TileEntityMekanism
implements ISideConfiguration,
IConfigCardAccess,
IHasMode {
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.func_191196_a();
    private static final int BASE_TICKS_REQUIRED = 40;
    private final CraftingInventory dummyInv = MekanismUtils.getDummyCraftingInv();
    public int ticksRequired = 40;
    public int operatingTicks;
    public boolean autoMode = false;
    public boolean isRecipe = false;
    public boolean stockControl = false;
    public boolean needsOrganize = true;
    private final HashedItem[] stockControlMap = new HashedItem[18];
    public int pulseOperations;
    public RecipeFormula formula;
    @Nullable
    private ICraftingRecipe cachedRecipe = null;
    private NonNullList<ItemStack> lastRemainingItems = EMPTY_LIST;
    public final TileComponentEjector ejectorComponent;
    public final TileComponentConfig configComponent;
    public ItemStack lastFormulaStack = ItemStack.field_190927_a;
    public ItemStack lastOutputStack = ItemStack.field_190927_a;
    private MachineEnergyContainer<TileEntityFormulaicAssemblicator> energyContainer;
    private List<IInventorySlot> craftingGridSlots;
    private List<IInventorySlot> inputSlots;
    private List<IInventorySlot> outputSlots;
    private FormulaInventorySlot formulaSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityFormulaicAssemblicator() {
        super(MekanismBlocks.FORMULAIC_ASSEMBLICATOR);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.setupItemIOConfig(this.inputSlots, this.outputSlots, this.energySlot, false);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        int slotX;
        int slotY;
        this.craftingGridSlots = new ArrayList<IInventorySlot>();
        this.inputSlots = new ArrayList<IInventorySlot>();
        this.outputSlots = new ArrayList<IInventorySlot>();
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.formulaSlot = FormulaInventorySlot.at(this, 6, 26);
        builder.addSlot(this.formulaSlot);
        for (slotY = 0; slotY < 2; ++slotY) {
            for (slotX = 0; slotX < 9; ++slotX) {
                int index = slotY * 9 + slotX;
                InputInventorySlot inputSlot = InputInventorySlot.at(stack -> {
                    if (this.formula == null) {
                        return true;
                    }
                    IntList indices = this.formula.getIngredientIndices(this.field_145850_b, (ItemStack)stack);
                    if (!indices.isEmpty()) {
                        HashedItem stockItem = this.stockControlMap[index];
                        if (!this.stockControl || stockItem == null) {
                            return true;
                        }
                        return ItemHandlerHelper.canItemStacksStack((ItemStack)stockItem.getStack(), (ItemStack)stack);
                    }
                    return false;
                }, item -> true, (IContentsListener)this, 8 + slotX * 18, 98 + slotY * 18);
                builder.addSlot(inputSlot);
                this.inputSlots.add(inputSlot);
            }
        }
        for (slotY = 0; slotY < 3; ++slotY) {
            for (slotX = 0; slotX < 3; ++slotX) {
                FormulaicCraftingSlot craftingSlot = FormulaicCraftingSlot.at(() -> this.autoMode, (IContentsListener)this, 26 + slotX * 18, 17 + slotY * 18);
                builder.addSlot(craftingSlot);
                this.craftingGridSlots.add(craftingSlot);
            }
        }
        for (slotY = 0; slotY < 3; ++slotY) {
            for (slotX = 0; slotX < 2; ++slotX) {
                OutputInventorySlot outputSlot = OutputInventorySlot.at(this, 116 + slotX * 18, 17 + slotY * 18);
                builder.addSlot(outputSlot);
                this.outputSlots.add(outputSlot);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityFormulaicAssemblicator)this).func_145831_w(), this, 152, 76);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    public FormulaInventorySlot getFormulaSlot() {
        return this.formulaSlot;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.checkFormula();
            this.recalculateRecipe();
        }
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.cachedRecipe = null;
            this.recalculateRecipe();
        }
        if (this.formula != null && this.stockControl && this.needsOrganize) {
            this.needsOrganize = false;
            this.buildStockControlMap();
            this.organizeStock();
        }
        this.energySlot.fillContainerOrConvert();
        if (this.getControlType() != IRedstoneControl.RedstoneControl.PULSE) {
            this.pulseOperations = 0;
        } else if (MekanismUtils.canFunction(this)) {
            ++this.pulseOperations;
        }
        this.checkFormula();
        if (this.autoMode && this.formula == null) {
            this.nextMode();
        }
        if (this.autoMode && this.formula != null && (this.getControlType() == IRedstoneControl.RedstoneControl.PULSE && this.pulseOperations > 0 || MekanismUtils.canFunction(this))) {
            boolean canOperate = true;
            if (!this.isRecipe) {
                canOperate = this.moveItemsToGrid();
            }
            if (canOperate) {
                this.isRecipe = true;
                if (this.operatingTicks >= this.ticksRequired) {
                    if (this.doSingleCraft()) {
                        this.operatingTicks = 0;
                        if (this.pulseOperations > 0) {
                            --this.pulseOperations;
                        }
                    }
                } else {
                    FloatingLong energyPerTick = this.energyContainer.getEnergyPerTick();
                    if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                        this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                        ++this.operatingTicks;
                    }
                }
            } else {
                this.operatingTicks = 0;
            }
        } else {
            this.operatingTicks = 0;
        }
    }

    private void checkFormula() {
        ItemStack formulaStack = this.formulaSlot.getStack();
        if (!formulaStack.func_190926_b() && formulaStack.func_77973_b() instanceof ItemCraftingFormula) {
            if (this.formula == null || this.lastFormulaStack != formulaStack) {
                this.loadFormula();
            }
        } else {
            this.formula = null;
        }
        this.lastFormulaStack = formulaStack;
    }

    private void loadFormula() {
        ItemStack formulaStack = this.formulaSlot.getStack();
        ItemCraftingFormula formulaItem = (ItemCraftingFormula)formulaStack.func_77973_b();
        if (formulaItem.isInvalid(formulaStack)) {
            this.formula = null;
            return;
        }
        NonNullList<ItemStack> formulaInventory = formulaItem.getInventory(formulaStack);
        if (formulaInventory == null) {
            this.formula = null;
        } else {
            RecipeFormula recipe = new RecipeFormula(this.field_145850_b, formulaInventory);
            if (recipe.isValidFormula()) {
                if (this.formula == null) {
                    this.formula = recipe;
                } else if (!this.formula.isFormulaEqual(recipe)) {
                    this.formula = recipe;
                    this.operatingTicks = 0;
                }
            } else {
                this.formula = null;
                formulaItem.setInvalid(formulaStack, true);
            }
        }
    }

    @Override
    public void markDirty(boolean recheckBlockState) {
        super.markDirty(recheckBlockState);
        this.recalculateRecipe();
    }

    private void recalculateRecipe() {
        if (this.field_145850_b != null && !this.isRemote()) {
            if (this.formula == null || !this.formula.isValidFormula()) {
                for (int i = 0; i < this.craftingGridSlots.size(); ++i) {
                    this.dummyInv.func_70299_a(i, StackUtils.size(this.craftingGridSlots.get(i).getStack(), 1));
                }
                this.lastRemainingItems = EMPTY_LIST;
                if (this.cachedRecipe == null || !this.cachedRecipe.func_77569_a((IInventory)this.dummyInv, this.field_145850_b)) {
                    this.cachedRecipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.dummyInv, this.field_145850_b).orElse(null);
                }
                if (this.cachedRecipe != null) {
                    this.lastOutputStack = this.cachedRecipe.func_77572_b((IInventory)this.dummyInv);
                    this.lastRemainingItems = this.cachedRecipe.func_179532_b((IInventory)this.dummyInv);
                } else {
                    this.lastOutputStack = MekanismUtils.findRepairRecipe(this.dummyInv, this.field_145850_b);
                }
                this.isRecipe = !this.lastOutputStack.func_190926_b();
            } else {
                this.isRecipe = this.formula.matches(this.field_145850_b, this.craftingGridSlots);
                if (this.isRecipe) {
                    this.lastOutputStack = this.formula.recipe.func_77572_b((IInventory)this.dummyInv);
                    this.lastRemainingItems = this.formula.recipe.func_179532_b((IInventory)this.dummyInv);
                } else {
                    this.lastOutputStack = ItemStack.field_190927_a;
                }
            }
            this.needsOrganize = true;
        }
    }

    private boolean doSingleCraft() {
        for (int i = 0; i < this.craftingGridSlots.size(); ++i) {
            this.dummyInv.func_70299_a(i, StackUtils.size(this.craftingGridSlots.get(i).getStack(), 1));
        }
        this.recalculateRecipe();
        ItemStack output = this.lastOutputStack;
        if (!output.func_190926_b() && this.tryMoveToOutput(output, Action.SIMULATE) && (this.lastRemainingItems.isEmpty() || this.lastRemainingItems.stream().allMatch(it -> it.func_190926_b() || this.tryMoveToOutput((ItemStack)it, Action.SIMULATE)))) {
            this.tryMoveToOutput(output, Action.EXECUTE);
            for (ItemStack remainingItem : this.lastRemainingItems) {
                if (remainingItem.func_190926_b()) continue;
                this.tryMoveToOutput(remainingItem, Action.EXECUTE);
            }
            for (IInventorySlot craftingSlot : this.craftingGridSlots) {
                if (craftingSlot.isEmpty()) continue;
                MekanismUtils.logMismatchedStackSize(craftingSlot.shrinkStack(1, Action.EXECUTE), 1L);
            }
            if (this.formula != null) {
                this.moveItemsToGrid();
            }
            this.markDirty(false);
            return true;
        }
        return false;
    }

    public boolean craftSingle() {
        if (this.formula == null) {
            return this.doSingleCraft();
        }
        boolean canOperate = true;
        if (!this.formula.matches(this.func_145831_w(), this.craftingGridSlots)) {
            canOperate = this.moveItemsToGrid();
        }
        if (canOperate) {
            return this.doSingleCraft();
        }
        return false;
    }

    private boolean moveItemsToGrid() {
        boolean ret = true;
        for (int i = 0; i < this.craftingGridSlots.size(); ++i) {
            IInventorySlot recipeSlot = this.craftingGridSlots.get(i);
            ItemStack recipeStack = recipeSlot.getStack();
            if (this.formula.isIngredientInPos(this.field_145850_b, recipeStack, i)) continue;
            if (recipeStack.func_190926_b()) {
                boolean found = false;
                for (int j = this.inputSlots.size() - 1; j >= 0; --j) {
                    ItemStack stockStack;
                    IInventorySlot stockSlot = this.inputSlots.get(j);
                    if (stockSlot.isEmpty() || !this.formula.isIngredientInPos(this.field_145850_b, stockStack = stockSlot.getStack(), i)) continue;
                    recipeSlot.setStack(StackUtils.size(stockStack, 1));
                    MekanismUtils.logMismatchedStackSize(stockSlot.shrinkStack(1, Action.EXECUTE), 1L);
                    this.markDirty(false);
                    found = true;
                    break;
                }
                if (found) continue;
                ret = false;
                continue;
            }
            recipeStack = this.tryMoveToInput(recipeStack);
            recipeSlot.setStack(recipeStack);
            this.markDirty(false);
            if (recipeStack.func_190926_b()) continue;
            ret = false;
        }
        return ret;
    }

    public void craftAll() {
        while (this.craftSingle()) {
        }
    }

    public void moveItems() {
        if (this.formula == null) {
            this.moveItemsToInput(true);
        } else {
            this.moveItemsToGrid();
        }
    }

    private void moveItemsToInput(boolean forcePush) {
        for (int i = 0; i < this.craftingGridSlots.size(); ++i) {
            IInventorySlot recipeSlot = this.craftingGridSlots.get(i);
            ItemStack recipeStack = recipeSlot.getStack();
            if (recipeStack.func_190926_b() || !forcePush && (this.formula == null || this.formula.isIngredientInPos(this.func_145831_w(), recipeStack, i))) continue;
            recipeSlot.setStack(this.tryMoveToInput(recipeStack));
        }
        this.markDirty(false);
    }

    @Override
    public void nextMode() {
        if (this.autoMode) {
            this.operatingTicks = 0;
            this.autoMode = false;
        } else if (this.formula != null) {
            this.moveItemsToInput(false);
            this.autoMode = true;
        }
        this.markDirty(false);
    }

    public void toggleStockControl() {
        if (!this.isRemote() && this.formula != null) {
            boolean bl = this.stockControl = !this.stockControl;
            if (this.stockControl) {
                this.organizeStock();
            }
        }
    }

    private void organizeStock() {
        if (this.formula == null) {
            return;
        }
        Object2IntOpenHashMap storedMap = new Object2IntOpenHashMap();
        for (IInventorySlot inputSlot : this.inputSlots) {
            ItemStack stack = inputSlot.getStack();
            if (stack.func_190926_b()) continue;
            HashedItem hashed = HashedItem.create(stack);
            storedMap.put((Object)hashed, storedMap.getOrDefault((Object)hashed, 0) + stack.func_190916_E());
        }
        IntOpenHashSet unused = new IntOpenHashSet();
        for (int i = 0; i < this.inputSlots.size(); ++i) {
            HashedItem hashedItem = this.stockControlMap[i];
            if (hashedItem == null) {
                unused.add(i);
                continue;
            }
            if (storedMap.containsKey((Object)hashedItem)) {
                int stored = storedMap.getInt((Object)hashedItem);
                int count = Math.min(hashedItem.getStack().func_77976_d(), stored);
                if (count == stored) {
                    storedMap.removeInt((Object)hashedItem);
                } else {
                    storedMap.put((Object)hashedItem, stored - count);
                }
                TileEntityFormulaicAssemblicator.setSlotIfChanged(this.inputSlots.get(i), hashedItem, count);
                continue;
            }
            IInventorySlot slot = this.inputSlots.get(i);
            if (slot.isEmpty()) continue;
            slot.setEmpty();
        }
        boolean empty = storedMap.isEmpty();
        IntIterator intIterator = unused.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            IInventorySlot slot = this.inputSlots.get(i);
            if (empty) {
                if (slot.isEmpty()) continue;
                slot.setEmpty();
                continue;
            }
            empty = this.setSlotIfChanged((Object2IntMap<HashedItem>)storedMap, slot);
        }
        if (empty) {
            return;
        }
        for (IInventorySlot inputSlot : this.inputSlots) {
            if (!inputSlot.isEmpty() || !this.setSlotIfChanged((Object2IntMap<HashedItem>)storedMap, inputSlot)) continue;
            return;
        }
        if (!storedMap.isEmpty()) {
            Mekanism.logger.error("Critical error: Formulaic Assemblicator had items left over after organizing stock. Impossible!");
        }
    }

    private boolean setSlotIfChanged(Object2IntMap<HashedItem> storedMap, IInventorySlot inputSlot) {
        boolean empty = false;
        Object2IntMap.Entry next = (Object2IntMap.Entry)storedMap.object2IntEntrySet().iterator().next();
        HashedItem item = (HashedItem)next.getKey();
        int stored = next.getIntValue();
        int count = Math.min(item.getStack().func_77976_d(), stored);
        if (count == stored) {
            storedMap.removeInt((Object)item);
            empty = storedMap.isEmpty();
        } else {
            next.setValue(stored - count);
        }
        TileEntityFormulaicAssemblicator.setSlotIfChanged(inputSlot, item, count);
        return empty;
    }

    private static void setSlotIfChanged(IInventorySlot slot, HashedItem item, int count) {
        ItemStack stack = item.createStack(count);
        if (!ItemStack.func_77989_b((ItemStack)slot.getStack(), (ItemStack)stack)) {
            slot.setStack(stack);
        }
    }

    private void buildStockControlMap() {
        if (this.formula == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            HashedItem hashedItem;
            int j = i * 2;
            ItemStack stack = this.formula.getInputStack(i);
            if (stack.func_190926_b()) {
                this.stockControlMap[j] = null;
                this.stockControlMap[j + 1] = null;
                continue;
            }
            this.stockControlMap[j] = hashedItem = HashedItem.create(stack);
            this.stockControlMap[j + 1] = hashedItem;
        }
    }

    private ItemStack tryMoveToInput(ItemStack stack) {
        IInventorySlot stockSlot;
        Iterator<IInventorySlot> iterator = this.inputSlots.iterator();
        while (iterator.hasNext() && !(stack = (stockSlot = iterator.next()).insertItem(stack, Action.EXECUTE, AutomationType.INTERNAL)).func_190926_b()) {
        }
        return stack;
    }

    private boolean tryMoveToOutput(ItemStack stack, Action action) {
        IInventorySlot outputSlot;
        Iterator<IInventorySlot> iterator = this.outputSlots.iterator();
        while (iterator.hasNext() && !(stack = (outputSlot = iterator.next()).insertItem(stack, action, AutomationType.INTERNAL)).func_190926_b()) {
        }
        return stack.func_190926_b();
    }

    public void encodeFormula() {
        RecipeFormula formula;
        ItemCraftingFormula item;
        ItemStack formulaStack;
        if (!this.formulaSlot.isEmpty() && (formulaStack = this.formulaSlot.getStack()).func_77973_b() instanceof ItemCraftingFormula && (item = (ItemCraftingFormula)formulaStack.func_77973_b()).getInventory(formulaStack) == null && (formula = new RecipeFormula(this.field_145850_b, this.craftingGridSlots)).isValidFormula()) {
            item.setInventory(formulaStack, formula.input);
            this.markDirty(false);
        }
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        this.autoMode = nbtTags.func_74767_n("auto");
        this.operatingTicks = nbtTags.func_74762_e("progress");
        this.pulseOperations = nbtTags.func_74762_e("pulse");
        this.stockControl = nbtTags.func_74767_n("stockControl");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("auto", this.autoMode);
        nbtTags.func_74768_a("progress", this.operatingTicks);
        nbtTags.func_74768_a("pulse", this.pulseOperations);
        nbtTags.func_74757_a("stockControl", this.stockControl);
        return nbtTags;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public Direction getOrientation() {
        return this.getDirection();
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, 40);
        }
    }

    public MachineEnergyContainer<TileEntityFormulaicAssemblicator> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.autoMode, value -> {
            this.autoMode = value;
        }));
        container.track(SyncableInt.create(() -> this.operatingTicks, value -> {
            this.operatingTicks = value;
        }));
        container.track(SyncableInt.create(() -> this.ticksRequired, value -> {
            this.ticksRequired = value;
        }));
        container.track(SyncableBoolean.create(() -> this.isRecipe, value -> {
            this.isRecipe = value;
        }));
        container.track(SyncableBoolean.create(() -> this.stockControl, value -> {
            this.stockControl = value;
        }));
        container.track(SyncableBoolean.create(() -> this.formula != null, hasFormula -> {
            if (hasFormula) {
                if (this.formula == null && this.isRemote()) {
                    this.formula = new RecipeFormula(this.func_145831_w(), (NonNullList<ItemStack>)NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a));
                }
            } else {
                this.formula = null;
            }
        }));
        int i = 0;
        while (i < 9) {
            int index = i++;
            container.track(SyncableItemStack.create(() -> this.formula == null ? ItemStack.field_190927_a : (ItemStack)this.formula.input.get(index), stack -> {
                if (!stack.func_190926_b() && this.formula == null && this.isRemote()) {
                    this.formula = new RecipeFormula(this.func_145831_w(), (NonNullList<ItemStack>)NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a));
                }
                if (this.formula != null) {
                    this.formula.setStack(this.func_145831_w(), index, (ItemStack)stack);
                }
            }));
        }
    }
}

