/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.api.IConfigurable;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;

public abstract class TileEntityStructuralMultiblock
extends TileEntityMekanism
implements IStructuralMultiblock,
IConfigurable {
    private final Map<MultiblockManager<?>, Structure> structures = new HashMap();
    private final Structure invalidStructure = Structure.INVALID;
    private final MultiblockData defaultMultiblock = new MultiblockData(this);
    private String clientActiveMultiblock = null;

    public TileEntityStructuralMultiblock(IBlockProvider provider) {
        super(provider);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    public MultiblockData getDefaultData() {
        return this.defaultMultiblock;
    }

    @Override
    public void setStructure(MultiblockManager<?> manager, Structure structure) {
        this.structures.put(manager, structure);
    }

    @Override
    public Structure getStructure(MultiblockManager<?> manager) {
        return this.structures.getOrDefault(manager, this.invalidStructure);
    }

    @Override
    public boolean hasStructure(Structure structure) {
        return this.structures.get(structure.getManager()) == structure;
    }

    @Override
    public boolean hasFormedMultiblock() {
        return this.clientActiveMultiblock != null;
    }

    @Override
    public boolean structuralGuiAccessAllowed() {
        return this.hasFormedMultiblock() && !this.clientActiveMultiblock.contains("fusion") && !this.clientActiveMultiblock.contains("evaporation");
    }

    @Override
    public Map<MultiblockManager<?>, Structure> getStructureMap() {
        return this.structures;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.structures.entrySet().removeIf(entry -> !((Structure)entry.getValue()).isValid());
        if (this.ticker >= 3 && this.structures.isEmpty()) {
            this.invalidStructure.tick(this);
        }
        String activeMultiblock = null;
        for (Structure s : this.structures.values()) {
            IMultiblock<?> master = s.getController();
            if (master == null || !this.getMultiblockData(s.getManager()).isFormed()) continue;
            activeMultiblock = master.getManager().getName().toLowerCase(Locale.ROOT);
            break;
        }
        if (!Objects.equals(activeMultiblock, this.clientActiveMultiblock)) {
            this.clientActiveMultiblock = activeMultiblock;
            this.sendUpdatePacket();
        }
    }

    @Override
    public ActionResultType onActivate(PlayerEntity player, Hand hand, ItemStack stack) {
        for (Map.Entry<MultiblockManager<?>, Structure> entry : this.structures.entrySet()) {
            IMultiblock<?> master = entry.getValue().getController();
            if (master == null || !this.getMultiblockData(entry.getKey()).isFormed() || !entry.getValue().getMultiblockData().getBounds().getRelativeLocation(this.func_174877_v()).isWall()) continue;
            return master.onActivate(player, hand, stack);
        }
        return ActionResultType.PASS;
    }

    @Override
    public void onNeighborChange(Block block, BlockPos neighborPos) {
        super.onNeighborChange(block, neighborPos);
        if (!this.isRemote()) {
            for (Structure s : this.structures.values()) {
                MultiblockData multiblockData;
                if (s.getController() == null || !(multiblockData = this.getMultiblockData(s.getManager())).isPositionInsideBounds(s, neighborPos) || multiblockData.innerNodes.contains(neighborPos) && !this.field_145850_b.func_175623_d(neighborPos)) continue;
                s.markForUpdate(this.field_145850_b, true);
            }
        }
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            for (Structure s : this.structures.values()) {
                FormationProtocol.FormationResult result;
                IMultiblock<?> master = s.getController();
                if (master == null || this.getMultiblockData(s.getManager()).isFormed() || (result = s.runUpdate(this)).isFormed() || result.getResultText() == null) continue;
                player.func_145747_a(result.getResultText(), Util.field_240973_b_);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        if (this.clientActiveMultiblock != null) {
            updateTag.func_74778_a("activeState", this.clientActiveMultiblock);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.clientActiveMultiblock = tag.func_150297_b("activeState", 8) ? tag.func_74779_i("activeState") : null;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.isRemote()) {
            this.structures.values().forEach(s -> s.invalidate(this.field_145850_b));
        }
    }

    @Override
    protected void dumpRadiation() {
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.isRemote()) {
            this.structures.values().forEach(s -> s.invalidate(this.field_145850_b));
        }
    }
}

