/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.event;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.FurnitureMod;
import com.mrcrayfish.furniture.client.gui.widget.button.IconButton;
import com.mrcrayfish.furniture.client.gui.widget.button.TagButton;
import com.mrcrayfish.furniture.core.ModBlocks;
import com.mrcrayfish.furniture.core.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CreativeScreenEvents {
    private static final ResourceLocation ICONS = new ResourceLocation("cfm", "textures/gui/icons.png");
    private static int startIndex;
    private List<TagFilter> filters;
    private List<TagButton> buttons;
    private Button btnScrollUp;
    private Button btnScrollDown;
    private Button btnEnableAll;
    private Button btnDisableAll;
    private boolean viewingFurnitureTab;
    private int guiCenterX = 0;
    private int guiCenterY = 0;

    @SubscribeEvent
    public void onPlayerLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.filters = null;
    }

    @SubscribeEvent
    public void onScreenInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof CreativeScreen) {
            if (this.filters == null) {
                this.compileItems();
            }
            this.viewingFurnitureTab = false;
            this.guiCenterX = ((CreativeScreen)event.getGui()).getGuiLeft();
            this.guiCenterY = ((CreativeScreen)event.getGui()).getGuiTop();
            this.buttons = new ArrayList<TagButton>();
            this.btnScrollUp = new IconButton(this.guiCenterX - 22, this.guiCenterY - 12, I18n.func_135052_a((String)"gui.button.cfm.scroll_filters_up", (Object[])new Object[0]), button -> {
                if (startIndex > 0) {
                    --startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 64, 0);
            event.addWidget((Widget)this.btnScrollUp);
            this.btnScrollDown = new IconButton(this.guiCenterX - 22, this.guiCenterY + 127, I18n.func_135052_a((String)"gui.button.cfm.scroll_filters_down", (Object[])new Object[0]), button -> {
                if (startIndex <= this.filters.size() - 4 - 1) {
                    ++startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 80, 0);
            event.addWidget((Widget)this.btnScrollDown);
            this.btnEnableAll = new IconButton(this.guiCenterX - 50, this.guiCenterY + 10, I18n.func_135052_a((String)"gui.button.cfm.enable_filters", (Object[])new Object[0]), button -> {
                this.filters.forEach(filters -> filters.setEnabled(true));
                this.buttons.forEach(TagButton::updateState);
                Screen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof CreativeScreen) {
                    this.updateItems((CreativeScreen)screen);
                }
            }, ICONS, 96, 0);
            event.addWidget((Widget)this.btnEnableAll);
            this.btnDisableAll = new IconButton(this.guiCenterX - 50, this.guiCenterY + 32, I18n.func_135052_a((String)"gui.button.cfm.disable_filters", (Object[])new Object[0]), button -> {
                this.filters.forEach(filters -> filters.setEnabled(false));
                this.buttons.forEach(TagButton::updateState);
                Screen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof CreativeScreen) {
                    this.updateItems((CreativeScreen)screen);
                }
            }, ICONS, 112, 0);
            event.addWidget((Widget)this.btnDisableAll);
            this.btnScrollUp.field_230694_p_ = false;
            this.btnScrollDown.field_230694_p_ = false;
            this.btnEnableAll.field_230694_p_ = false;
            this.btnDisableAll.field_230694_p_ = false;
            this.updateTagButtons();
            CreativeScreen screen = (CreativeScreen)event.getGui();
            if (screen.func_147056_g() == FurnitureMod.GROUP.func_78021_a()) {
                this.btnScrollUp.field_230694_p_ = true;
                this.btnScrollDown.field_230694_p_ = true;
                this.btnEnableAll.field_230694_p_ = true;
                this.btnDisableAll.field_230694_p_ = true;
                this.viewingFurnitureTab = true;
                this.buttons.forEach(button -> {
                    button.field_230694_p_ = true;
                });
                this.updateItems(screen);
            }
        }
    }

    @SubscribeEvent
    public void onScreenClick(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (event.getButton() != 0) {
            return;
        }
        if (event.getGui() instanceof CreativeScreen) {
            for (Button button : this.buttons) {
                if (!button.func_231047_b_(event.getMouseX(), event.getMouseY()) || !button.func_231044_a_(event.getMouseX(), event.getMouseY(), event.getButton())) continue;
                return;
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (event.getGui() instanceof CreativeScreen) {
            CreativeScreen screen = (CreativeScreen)event.getGui();
            if (screen.func_147056_g() == FurnitureMod.GROUP.func_78021_a()) {
                if (!this.viewingFurnitureTab) {
                    this.updateItems(screen);
                    this.viewingFurnitureTab = true;
                }
            } else {
                this.viewingFurnitureTab = false;
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof CreativeScreen) {
            CreativeScreen screen = (CreativeScreen)event.getGui();
            this.guiCenterX = screen.getGuiLeft();
            this.guiCenterY = screen.getGuiTop();
            if (screen.func_147056_g() == FurnitureMod.GROUP.func_78021_a()) {
                this.btnScrollUp.field_230694_p_ = true;
                this.btnScrollDown.field_230694_p_ = true;
                this.btnEnableAll.field_230694_p_ = true;
                this.btnDisableAll.field_230694_p_ = true;
                this.buttons.forEach(button -> {
                    button.field_230694_p_ = true;
                });
                this.buttons.forEach(button -> button.func_230430_a_(event.getMatrixStack(), event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks()));
                this.buttons.forEach(button -> {
                    if (button.func_231047_b_(event.getMouseX(), event.getMouseY())) {
                        screen.func_238652_a_(event.getMatrixStack(), ITextComponent.func_244388_a((String)button.getCategory().getName()), event.getMouseX(), event.getMouseY());
                    }
                });
                if (this.btnEnableAll.func_231047_b_((double)event.getMouseX(), (double)event.getMouseY())) {
                    screen.func_238652_a_(event.getMatrixStack(), ITextComponent.func_244388_a((String)this.btnEnableAll.func_230458_i_().getString()), event.getMouseX(), event.getMouseY());
                }
                if (this.btnDisableAll.func_231047_b_((double)event.getMouseX(), (double)event.getMouseY())) {
                    screen.func_238652_a_(event.getMatrixStack(), ITextComponent.func_244388_a((String)this.btnDisableAll.func_230458_i_().getString()), event.getMouseX(), event.getMouseY());
                }
            } else {
                this.btnScrollUp.field_230694_p_ = false;
                this.btnScrollDown.field_230694_p_ = false;
                this.btnEnableAll.field_230694_p_ = false;
                this.btnDisableAll.field_230694_p_ = false;
                this.buttons.forEach(button -> {
                    button.field_230694_p_ = false;
                });
            }
        }
    }

    private void updateTagButtons() {
        Button.IPressable pressable = button -> {
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof CreativeScreen) {
                this.updateItems((CreativeScreen)screen);
            }
        };
        this.buttons.clear();
        for (int i = startIndex; i < startIndex + 4 && i < this.filters.size(); ++i) {
            TagButton button2 = new TagButton(this.guiCenterX - 28, this.guiCenterY + 29 * (i - startIndex) + 10, this.filters.get(i), pressable);
            this.buttons.add(button2);
        }
        this.btnScrollUp.field_230693_o_ = startIndex > 0;
        this.btnScrollDown.field_230693_o_ = startIndex <= this.filters.size() - 4 - 1;
    }

    private void updateItems(CreativeScreen screen) {
        CreativeScreen.CreativeContainer container = (CreativeScreen.CreativeContainer)screen.func_212873_a_();
        LinkedHashSet<Item> categorisedItems = new LinkedHashSet<Item>();
        for (TagFilter filter : this.filters) {
            if (!filter.isEnabled()) continue;
            categorisedItems.addAll(filter.getItems());
        }
        container.field_148330_a.clear();
        categorisedItems.forEach(item -> container.field_148330_a.add((Object)new ItemStack((IItemProvider)item)));
        container.field_148330_a.sort(Comparator.comparingInt(o -> Item.func_150891_b((Item)o.func_77973_b())));
        container.func_148329_a(0.0f);
    }

    private void compileItems() {
        TagFilter GENERAL = new TagFilter(new ResourceLocation("cfm", "general"), new ItemStack((IItemProvider)ModBlocks.CHAIR_OAK));
        TagFilter STORAGE = new TagFilter(new ResourceLocation("cfm", "storage"), new ItemStack((IItemProvider)ModBlocks.CABINET_OAK));
        TagFilter BEDROOM = new TagFilter(new ResourceLocation("cfm", "bedroom"), new ItemStack((IItemProvider)ModBlocks.DESK_OAK));
        TagFilter OUTDOORS = new TagFilter(new ResourceLocation("cfm", "outdoors"), new ItemStack((IItemProvider)ModBlocks.MAIL_BOX_OAK));
        TagFilter KITCHEN = new TagFilter(new ResourceLocation("cfm", "kitchen"), new ItemStack((IItemProvider)ModBlocks.KITCHEN_COUNTER_CYAN));
        TagFilter ITEMS = new TagFilter(new ResourceLocation("cfm", "items"), new ItemStack((IItemProvider)ModItems.SPATULA));
        TagFilter[] filters = new TagFilter[]{GENERAL, STORAGE, BEDROOM, OUTDOORS, KITCHEN, ITEMS};
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.func_77640_w() == FurnitureMod.GROUP).filter(item -> item.getRegistryName().func_110624_b().equals("cfm")).forEach(item -> item.getTags().forEach(location -> {
            for (TagFilter filter : filters) {
                if (!location.equals((Object)filter.getTag())) continue;
                filter.add((Item)item);
            }
        }));
        this.filters = new ArrayList<TagFilter>();
        this.filters.addAll(Arrays.asList(filters));
    }

    public static class TagFilter {
        private ResourceLocation tag;
        private String translationKey;
        private ItemStack icon;
        private boolean enabled = true;
        private List<Item> items = Lists.newArrayList();

        public TagFilter(ResourceLocation tag, ItemStack icon) {
            this.tag = tag;
            this.translationKey = String.format("gui.tag_filter.%s.%s", tag.func_110624_b(), tag.func_110623_a().replace("/", "."));
            this.icon = icon;
        }

        public ResourceLocation getTag() {
            return this.tag;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public String getName() {
            return I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void add(Item item) {
            this.items.add(item);
        }

        public void add(Block block) {
            this.items.add(Item.func_150898_a((Block)block));
        }

        public List<Item> getItems() {
            return this.items;
        }
    }
}

