/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network;

import com.mrcrayfish.furniture.network.message.IMessage;
import com.mrcrayfish.furniture.network.message.MessageFlipGrill;
import com.mrcrayfish.furniture.network.message.MessageLockCrate;
import com.mrcrayfish.furniture.network.message.MessageOpenMailBox;
import com.mrcrayfish.furniture.network.message.MessageRequestMailBoxes;
import com.mrcrayfish.furniture.network.message.MessageSendMail;
import com.mrcrayfish.furniture.network.message.MessageSetDoorMatMessage;
import com.mrcrayfish.furniture.network.message.MessageSetMailBoxName;
import com.mrcrayfish.furniture.network.message.MessageUpdateMailBoxes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    public static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel instance;
    private static int nextId;

    public static void init() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("cfm", "network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        PacketHandler.register(MessageLockCrate.class, new MessageLockCrate());
        PacketHandler.register(MessageRequestMailBoxes.class, new MessageRequestMailBoxes());
        PacketHandler.register(MessageUpdateMailBoxes.class, new MessageUpdateMailBoxes());
        PacketHandler.register(MessageSendMail.class, new MessageSendMail());
        PacketHandler.register(MessageSetMailBoxName.class, new MessageSetMailBoxName());
        PacketHandler.register(MessageOpenMailBox.class, new MessageOpenMailBox());
        PacketHandler.register(MessageFlipGrill.class, new MessageFlipGrill());
        PacketHandler.register(MessageSetDoorMatMessage.class, new MessageSetDoorMatMessage());
    }

    private static <T> void register(Class<T> clazz, IMessage<T> message) {
        instance.registerMessage(nextId++, clazz, message::encode, message::decode, message::handle);
    }

    static {
        nextId = 0;
    }
}

