/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core;

import com.craftingdead.core.IModDist;
import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.action.ActionTypes;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.capability.SerializableCapabilityProvider;
import com.craftingdead.core.capability.SimpleCapabilityProvider;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.command.Commands;
import com.craftingdead.core.data.ModItemTagsProvider;
import com.craftingdead.core.data.ModLootTableProvider;
import com.craftingdead.core.data.ModRecipeProvider;
import com.craftingdead.core.enchantment.ModEnchantments;
import com.craftingdead.core.entity.ModEntityTypes;
import com.craftingdead.core.event.CombatPickupEvent;
import com.craftingdead.core.inventory.container.ModContainerTypes;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.item.combatslot.CombatSlotType;
import com.craftingdead.core.item.crafting.ModRecipeSerializers;
import com.craftingdead.core.item.gun.ammoprovider.AmmoProviderTypes;
import com.craftingdead.core.item.hydration.DefaultHydration;
import com.craftingdead.core.item.hydration.PresetHydration;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.living.IPlayer;
import com.craftingdead.core.living.IPlayerExtension;
import com.craftingdead.core.living.LivingImpl;
import com.craftingdead.core.living.PlayerImpl;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.SyncLivingMessage;
import com.craftingdead.core.particle.ModParticleTypes;
import com.craftingdead.core.potion.ModEffects;
import com.craftingdead.core.server.ServerDist;
import com.craftingdead.core.util.ArbitraryTooltips;
import com.craftingdead.core.util.ModSoundEvents;
import com.mojang.brigadier.CommandDispatcher;
import io.netty.buffer.Unpooled;
import net.minecraft.command.CommandSource;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="craftingdead")
public class CraftingDead {
    public static final String ID = "craftingdead";
    public static final String VERSION = JarVersionLookupHandler.getImplementationVersion(CraftingDead.class).orElse("[version]");
    private static final String TRAVELERS_BACKPACK_ID = "travelersbackpack";
    public static final ServerConfig serverConfig;
    public static final ForgeConfigSpec serverConfigSpec;
    private static final Logger logger;
    private static CraftingDead instance;
    private final IModDist modDist;
    private boolean travelersBackpacksLoaded;

    public CraftingDead() {
        instance = this;
        this.modDist = (IModDist)DistExecutor.safeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleGatherData);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSoundEvents.SOUND_EVENTS.register(modEventBus);
        ModContainerTypes.CONTAINERS.register(modEventBus);
        ModEffects.EFFECTS.register(modEventBus);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
        ModParticleTypes.PARTICLE_TYPES.register(modEventBus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        ActionTypes.ACTION_TYPES.register(modEventBus);
        AmmoProviderTypes.AMMO_PROVIDER_TYPES.register(modEventBus);
        modEventBus.addGenericListener(Item.class, ArbitraryTooltips::registerAll);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverConfigSpec);
    }

    public IModDist getModDist() {
        return this.modDist;
    }

    public ClientDist getClientDist() {
        if (this.modDist instanceof ClientDist) {
            return (ClientDist)this.modDist;
        }
        throw new IllegalStateException("Accessing client dist on wrong side");
    }

    public boolean isTravelersBackpacksLoaded() {
        return this.travelersBackpacksLoaded;
    }

    public static CraftingDead getInstance() {
        return instance;
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        logger.info("Starting Crafting Dead, version {}", (Object)VERSION);
        NetworkChannel.loadChannels();
        this.travelersBackpacksLoaded = ModList.get().isLoaded(TRAVELERS_BACKPACK_ID);
        if (this.travelersBackpacksLoaded) {
            logger.info("Adding integration for travelersbackpack");
        }
        event.enqueueWork(() -> BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.SYRINGE.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), (ItemStack)new ItemStack((IItemProvider)ModItems.ADRENALINE_SYRINGE.get())));
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            dataGenerator.func_200390_a((IDataProvider)new ModItemTagsProvider(dataGenerator, (BlockTagsProvider)new ForgeBlockTagsProvider(dataGenerator, event.getExistingFileHelper()), event.getExistingFileHelper()));
            dataGenerator.func_200390_a((IDataProvider)new ModRecipeProvider(dataGenerator));
            dataGenerator.func_200390_a((IDataProvider)new ModLootTableProvider(dataGenerator));
        }
    }

    @SubscribeEvent
    public void handleEntityItemPickup(EntityItemPickupEvent event) {
        event.getPlayer().getCapability(ModCapabilities.LIVING).cast().filter(IPlayer::isCombatModeEnabled).ifPresent(living -> {
            CombatSlotType combatSlotType;
            ItemStack itemStack = event.getItem().func_92059_d();
            CombatPickupEvent combatPickupEvent = new CombatPickupEvent(itemStack, combatSlotType = (CombatSlotType)CombatSlotType.getSlotType(itemStack).orElse(null));
            if (MinecraftForge.EVENT_BUS.post((Event)combatPickupEvent)) {
                event.setCanceled(true);
            } else if (combatSlotType != null) {
                if (combatSlotType.addToInventory(itemStack, event.getPlayer().field_71071_by, false)) {
                    event.setResult(Event.Result.ALLOW);
                } else {
                    event.setCanceled(true);
                }
            }
        });
    }

    @SubscribeEvent
    public void handleRegisterCommands(RegisterCommandsEvent event) {
        Commands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingSetTarget(LivingSetAttackTargetEvent event) {
        MobEntity mobEntity;
        if (event.getTarget() != null && event.getEntityLiving() instanceof MobEntity && (mobEntity = (MobEntity)event.getEntityLiving()).func_70644_a((Effect)ModEffects.FLASH_BLINDNESS.get())) {
            mobEntity.func_70624_b(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().getCapability(ModCapabilities.LIVING).map(living -> living.onDeath(event.getSource())).orElse(false).booleanValue() || event.getSource().func_76346_g() != null && event.getSource().func_76346_g().getCapability(ModCapabilities.LIVING).map(living -> living.onKill(event.getEntity())).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingDrops(LivingDropsEvent event) {
        event.getEntity().getCapability(ModCapabilities.LIVING).ifPresent(living -> event.setCanceled(living.onDeathDrops(event.getSource(), event.getDrops())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingAttack(LivingAttackEvent event) {
        event.getEntity().getCapability(ModCapabilities.LIVING).ifPresent(living -> event.setCanceled(living.onAttacked(event.getSource(), event.getAmount())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingDamage(LivingDamageEvent event) {
        event.getEntity().getCapability(ModCapabilities.LIVING).ifPresent(living -> event.setAmount(living.onDamaged(event.getSource(), event.getAmount())));
    }

    @SubscribeEvent
    public void handlePlayerClone(PlayerEvent.Clone event) {
        IPlayer.getExpected(event.getPlayer()).copyFrom(IPlayer.getExpected(event.getOriginal()), event.isWasDeath());
    }

    @SubscribeEvent
    public void handleUseItem(LivingEntityUseItemEvent.Finish event) {
        event.getItem().getCapability(ModCapabilities.HYDRATION).map(hydration -> hydration.getHydration(event.getItem())).ifPresent(hydration -> event.getEntityLiving().func_195064_c(new EffectInstance((Effect)ModEffects.HYDRATE.get(), 1, hydration.intValue())));
    }

    @SubscribeEvent
    public void handleLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        event.getEntityLiving().getCapability(ModCapabilities.LIVING).ifPresent(living -> {
            living.tick();
            if (!living.getEntity().func_130014_f_().func_201670_d() && living.requiresSync()) {
                PacketBuffer data = new PacketBuffer(Unpooled.buffer());
                living.encode(data, false);
                NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(living::getEntity), (Object)new SyncLivingMessage(living.getEntity().func_145782_y(), data));
            }
        });
    }

    @SubscribeEvent
    public void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        switch (event.phase) {
            case END: {
                event.player.getCapability(ModCapabilities.LIVING).filter(living -> living instanceof IPlayer).map(living -> (IPlayer)living).ifPresent(IPlayerExtension::playerTick);
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            LivingImpl living = event.getObject() instanceof PlayerEntity ? new PlayerImpl<PlayerEntity>((PlayerEntity)event.getObject()) : new LivingImpl((LivingEntity)event.getObject());
            event.addCapability(ILiving.CAPABILITY_KEY, new SerializableCapabilityProvider(LazyOptional.of(() -> living), () -> ModCapabilities.LIVING, CompoundNBT::new));
            living.load();
        }
    }

    @SubscribeEvent
    public void handleAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).func_77973_b();
        int hydration = item == Items.field_151034_e || item == Items.field_179560_bq ? 2 : (item == Items.field_151172_bF || item == Items.field_185164_cV || item == Items.field_226638_pX_ ? 1 : (item == Items.field_185161_cS || item == Items.field_222112_pR ? 3 : (item == Items.field_196100_at || item == Items.field_151153_ao || item == Items.field_151009_A || item == Items.field_222115_pz || item == Items.field_185165_cW || item == Items.field_151127_ba ? 5 : (item == Items.field_151150_bK ? 6 : -1))));
        if (hydration != -1) {
            event.addCapability(new ResourceLocation(ID, "hydration"), new SimpleCapabilityProvider(LazyOptional.of(() -> new PresetHydration(hydration)), () -> ModCapabilities.HYDRATION));
        } else if (item == Items.field_151068_bn) {
            event.addCapability(new ResourceLocation(ID, "hydration"), new SimpleCapabilityProvider(LazyOptional.of(DefaultHydration::new), () -> ModCapabilities.HYDRATION));
        }
    }

    @SubscribeEvent
    public void handlePlayerStartTracking(PlayerEvent.StartTracking event) {
        event.getTarget().getCapability(ModCapabilities.LIVING).ifPresent(living -> {
            living.onStartTracking((ServerPlayerEntity)event.getPlayer());
            PacketBuffer data = new PacketBuffer(Unpooled.buffer());
            living.encode(data, true);
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SyncLivingMessage(living.getEntity().func_145782_y(), data));
        });
    }

    static {
        Pair serverConfigPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverConfigSpec = (ForgeConfigSpec)serverConfigPair.getRight();
        serverConfig = (ServerConfig)serverConfigPair.getLeft();
        logger = LogManager.getLogger();
    }
}

