/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.action;

import com.craftingdead.core.action.ActionType;
import com.craftingdead.core.action.IAction;
import com.craftingdead.core.living.ILiving;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractAction
implements IAction {
    private final ActionType<?> actionType;
    protected final ILiving<?, ?> performer;
    @Nullable
    protected ILiving<?, ?> target;

    public AbstractAction(ActionType<?> actionType, ILiving<?, ?> performer, @Nullable ILiving<?, ?> target) {
        this.actionType = actionType;
        this.performer = performer;
        this.target = target;
    }

    @Override
    public ActionType<?> getActionType() {
        return this.actionType;
    }

    @Override
    public ILiving<?, ?> getPerformer() {
        return this.performer;
    }

    @Override
    public ILiving.IProgressMonitor getPerformerProgress() {
        return new ActionProgress(true);
    }

    @Override
    public Optional<ILiving<?, ?>> getTarget() {
        return Optional.ofNullable(this.target);
    }

    @Override
    public ILiving.IProgressMonitor getTargetProgress() {
        return new ActionProgress(false);
    }

    protected String getTranslationKey() {
        return Util.func_200697_a((String)"action", (ResourceLocation)this.actionType.getRegistryName());
    }

    protected abstract float getProgress(float var1);

    private class ActionProgress
    implements ILiving.IProgressMonitor {
        private final boolean performer;

        public ActionProgress(boolean performer) {
            this.performer = performer;
        }

        @Override
        public ITextComponent getMessage() {
            return new TranslationTextComponent(AbstractAction.this.getTranslationKey() + ".message");
        }

        @Override
        public Optional<ITextComponent> getSubMessage() {
            return this.performer ? (AbstractAction.this.target == null ? Optional.empty() : Optional.of(new TranslationTextComponent("action.target", new Object[]{AbstractAction.this.target.getEntity().func_145748_c_().getString()}))) : Optional.of(new TranslationTextComponent("action.performer", new Object[]{AbstractAction.this.performer.getEntity().func_145748_c_().getString()}));
        }

        @Override
        public float getProgress(float partialTicks) {
            return AbstractAction.this.getProgress(partialTicks);
        }

        @Override
        public void stop() {
            AbstractAction.this.getPerformer().cancelAction(true);
        }
    }
}

