/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.action;

import com.craftingdead.core.action.ActionType;
import com.craftingdead.core.action.IAction;
import com.craftingdead.core.action.RemoveMagazineAction;
import com.craftingdead.core.action.item.BlockActionEntry;
import com.craftingdead.core.action.item.EntityActionEntry;
import com.craftingdead.core.action.item.UseItemAction;
import com.craftingdead.core.action.reload.MagazineReloadAction;
import com.craftingdead.core.action.reload.RefillableReloadAction;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.potion.ModEffects;
import com.craftingdead.core.tag.ModItemTags;
import com.craftingdead.core.util.ModDamageSource;
import java.util.function.Supplier;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class ActionTypes {
    public static final DeferredRegister<ActionType<?>> ACTION_TYPES = DeferredRegister.create(ActionType.class, (String)"craftingdead");
    public static final Lazy<IForgeRegistry<ActionType<?>>> REGISTRY = Lazy.of((Supplier)ACTION_TYPES.makeRegistry("action_types", RegistryBuilder::new));
    public static final RegistryObject<ActionType<?>> MAGAZINE_RELOAD = ACTION_TYPES.register("magazine_reload", () -> new ActionType<IAction>((actionType, performer, target) -> new MagazineReloadAction(performer), true));
    public static final RegistryObject<ActionType<?>> REFILLABLE_RELOAD = ACTION_TYPES.register("refillable_reload", () -> new ActionType<IAction>((actionType, performer, target) -> new RefillableReloadAction(performer), true));
    public static final RegistryObject<ActionType<?>> REMOVE_MAGAZINE = ACTION_TYPES.register("remove_magazine", () -> new ActionType<IAction>((actionType, performer, target) -> new RemoveMagazineAction(performer), true));
    public static final RegistryObject<ActionType<UseItemAction>> USE_CLEAN_RAG = ACTION_TYPES.register("use_clean_rag", () -> new ActionType<UseItemAction>((actionType, performer, target) -> UseItemAction.builder(actionType, performer, target).setHeldItemPredicate(item -> item == ModItems.CLEAN_RAG.get()).setTotalDurationTicks(16).addEntry(new EntityActionEntry((EntityActionEntry.Properties)new EntityActionEntry.Properties().setTargetSelector(EntityActionEntry.TargetSelector.SELF_AND_OTHERS.andThen(t -> t == null || !t.getEntity().func_70644_a((Effect)ModEffects.BLEEDING.get()) ? null : t)).setReturnItem((Supplier)ModItems.BLOODY_RAG))).build(), false));
    public static final RegistryObject<ActionType<UseItemAction>> USE_SPLINT = ACTION_TYPES.register("use_splint", () -> new ActionType<UseItemAction>((actionType, performer, target) -> UseItemAction.builder(actionType, performer, target).setHeldItemPredicate(item -> item == ModItems.SPLINT.get()).addEntry(new EntityActionEntry(new EntityActionEntry.Properties().setTargetSelector(EntityActionEntry.TargetSelector.SELF_AND_OTHERS.andThen(t -> t == null || !t.getEntity().func_70644_a((Effect)ModEffects.BROKEN_LEG.get()) ? null : t)))).build(), false));
    public static final RegistryObject<ActionType<UseItemAction>> USE_SYRINGE = ACTION_TYPES.register("use_syringe", () -> new ActionType<UseItemAction>((actionType, performer, target) -> UseItemAction.builder(actionType, performer, target).setHeldItemPredicate(item -> item == ModItems.SYRINGE.get()).setTotalDurationTicks(16).addEntry(new EntityActionEntry((EntityActionEntry.Properties)new EntityActionEntry.Properties().setTargetSelector(EntityActionEntry.TargetSelector.OTHERS_ONLY.ofType(ZombieEntity.class)).setCustomAction(Pair.of(t -> t.getEntity().func_70097_a(ModDamageSource.BLEEDING, 2.0f), (Object)Float.valueOf(0.25f))).setReturnItem((IItemProvider)ModItemTags.VIRUS_SYRINGE.func_230236_b_().get(0))), () -> !ModItemTags.VIRUS_SYRINGE.func_230236_b_().isEmpty()).addEntry(new EntityActionEntry((EntityActionEntry.Properties)new EntityActionEntry.Properties().setTargetSelector((p, t) -> {
        if (t == null || p == t) {
            return null;
        }
        Object targetEntity = t.getEntity();
        if (!(targetEntity instanceof ZombieEntity) && !(targetEntity instanceof SkeletonEntity)) {
            if (targetEntity.func_110143_aJ() > 4.0f) {
                return t;
            }
            if (p.getEntity() instanceof PlayerEntity) {
                ((PlayerEntity)p.getEntity()).func_146105_b((ITextComponent)new TranslationTextComponent("message.low_health", new Object[]{targetEntity.func_145748_c_()}).func_230530_a_(Style.field_240709_b_.func_240720_a_(new TextFormatting[]{TextFormatting.RED})), true);
            }
        }
        return null;
    }).setCustomAction(Pair.of(t -> t.getEntity().func_70097_a(ModDamageSource.BLEEDING, 2.0f), (Object)Float.valueOf(1.0f))).setReturnItem((Supplier)ModItems.BLOOD_SYRINGE))).build(), false));
    public static final RegistryObject<ActionType<UseItemAction>> USE_FIRST_AID_KIT = ACTION_TYPES.register("use_first_aid_kit", () -> new ActionType<UseItemAction>((actionType, performer, target) -> UseItemAction.builder(actionType, performer, target).setHeldItemPredicate(item -> item == ModItems.FIRST_AID_KIT.get()).setFreezeMovement(true).addEntry(new EntityActionEntry(new EntityActionEntry.Properties().setTargetSelector(EntityActionEntry.TargetSelector.SELF_AND_OTHERS).addEffect((Pair<EffectInstance, Float>)Pair.of((Object)new EffectInstance(Effects.field_76432_h, 1, 1), (Object)Float.valueOf(1.0f))))).build(), false));
    public static final RegistryObject<ActionType<UseItemAction>> USE_ADRENALINE_SYRINGE = ACTION_TYPES.register("use_adrenaline_syringe", () -> new ActionType<UseItemAction>((actionType, performer, target) -> UseItemAction.builder(actionType, performer, target).setHeldItemPredicate(item -> item == ModItems.ADRENALINE_SYRINGE.get()).setTotalDurationTicks(16).addEntry(new EntityActionEntry(((EntityActionEntry.Properties)((EntityActionEntry.Properties)new EntityActionEntry.Properties().setTargetSelector(EntityActionEntry.TargetSelector.SELF_AND_OTHERS).setReturnItem((Supplier)ModItems.SYRINGE)).setReturnItemInCreative(false)).addEffect((Pair<EffectInstance, Float>)Pair.of((Object)new EffectInstance((Effect)ModEffects.ADRENALINE.get(), 400, 1), (Object)Float.valueOf(1.0f))))).build(), false));
    public static final RegistryObject<ActionType<UseItemAction>> USE_BLOOD_SYRINGE = ACTION_TYPES.register("use_blood_syringe", () -> new ActionType<UseItemAction>((actionType, performer, target) -> UseItemAction.builder(actionType, performer, target).setHeldItemPredicate(item -> item == ModItems.BLOOD_SYRINGE.get()).setTotalDurationTicks(16).addEntry(new EntityActionEntry(((EntityActionEntry.Properties)((EntityActionEntry.Properties)new EntityActionEntry.Properties().setTargetSelector(EntityActionEntry.TargetSelector.SELF_AND_OTHERS).setReturnItem((Supplier)ModItems.SYRINGE)).setReturnItemInCreative(false)).addEffect((Pair<EffectInstance, Float>)Pair.of((Object)new EffectInstance(Effects.field_76432_h, 1, 0), (Object)Float.valueOf(1.0f))))).build(), false));
    public static final RegistryObject<ActionType<UseItemAction>> USE_BANDAGE = ACTION_TYPES.register("use_bandage", () -> new ActionType<UseItemAction>((actionType, performer, target) -> UseItemAction.builder(actionType, performer, target).setHeldItemPredicate(item -> item == ModItems.BANDAGE.get()).setTotalDurationTicks(16).addEntry(new EntityActionEntry(new EntityActionEntry.Properties().setTargetSelector(EntityActionEntry.TargetSelector.SELF_AND_OTHERS).addEffect((Pair<EffectInstance, Float>)Pair.of((Object)new EffectInstance(Effects.field_76432_h, 1, 0), (Object)Float.valueOf(1.0f))))).build(), false));
    public static final RegistryObject<ActionType<UseItemAction>> WASH_RAG = ACTION_TYPES.register("wash_rag", () -> new ActionType<UseItemAction>((actionType, performer, target) -> UseItemAction.builder(actionType, performer, target).setHeldItemPredicate(item -> item == ModItems.DIRTY_RAG.get() || item == ModItems.BLOODY_RAG.get()).addEntry(new BlockActionEntry(((BlockActionEntry.Properties)((BlockActionEntry.Properties)new BlockActionEntry.Properties().setReturnItem((Supplier)ModItems.CLEAN_RAG)).setFinishSound(SoundEvents.field_187630_M)).setPredicate(blockState -> blockState.func_204520_s().func_206886_c() == Fluids.field_204546_a))).build(), false));
}

