/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.action;

import com.craftingdead.core.action.ActionType;
import com.craftingdead.core.action.ActionTypes;
import com.craftingdead.core.action.TimedAction;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.item.animation.gun.AnimationType;
import com.craftingdead.core.item.animation.gun.GunAnimation;
import com.craftingdead.core.item.animation.gun.GunAnimationController;
import com.craftingdead.core.item.animation.gun.reload.GunAnimationReload;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.item.gun.ammoprovider.IAmmoProvider;
import com.craftingdead.core.item.gun.ammoprovider.MagazineAmmoProvider;
import com.craftingdead.core.living.ILiving;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class RemoveMagazineAction
extends TimedAction {
    private final IGun gun;
    private final ItemStack oldMagazineStack;
    private final MagazineAmmoProvider ammoProvider;

    public RemoveMagazineAction(ILiving<?, ?> performer) {
        super((ActionType)ActionTypes.REMOVE_MAGAZINE.get(), performer, null);
        this.gun = (IGun)performer.getEntity().func_184614_ca().getCapability(ModCapabilities.GUN).orElseThrow(() -> new IllegalStateException("Performer not holding gun"));
        IAmmoProvider ammoProvider = this.gun.getAmmoProvider();
        if (!(ammoProvider instanceof MagazineAmmoProvider)) {
            throw new IllegalStateException("No MagazineAmmoProvider present");
        }
        this.ammoProvider = (MagazineAmmoProvider)ammoProvider;
        this.oldMagazineStack = this.ammoProvider.getMagazineStack();
    }

    @Override
    protected int getTotalDurationTicks() {
        return this.gun.getReloadDurationTicks() / 2;
    }

    @Override
    public boolean start() {
        if (!this.getPerformer().getEntity().func_70051_ag() && !this.oldMagazineStack.func_190926_b()) {
            if (this.gun.isPerformingRightMouseAction()) {
                this.gun.setPerformingRightMouseAction(this.getPerformer(), false, false);
            }
            if (this.gun.getClient() != null) {
                this.gun.getAnimation(AnimationType.RELOAD).filter(animation -> animation instanceof GunAnimationReload).map(animation -> (GunAnimationReload)animation).ifPresent(animation -> {
                    animation.setEjectingClip(true);
                    this.gun.getClient().getAnimationController().addAnimation((GunAnimation)animation, () -> this.ammoProvider.setMagazineStack(ItemStack.field_190927_a));
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean tick() {
        if (this.getPerformer().getEntity().func_70051_ag()) {
            this.getPerformer().cancelAction(false);
            return false;
        }
        return super.tick();
    }

    @Override
    public void cancel() {
        super.cancel();
        this.gun.getAnimationController().ifPresent(GunAnimationController::removeCurrentAnimation);
        this.ammoProvider.setMagazineStack(this.oldMagazineStack);
    }

    @Override
    protected void finish() {
        if (!this.performer.getEntity().func_130014_f_().func_201670_d()) {
            this.ammoProvider.setMagazineStack(ItemStack.field_190927_a);
            if (!this.oldMagazineStack.func_190926_b() && this.performer.getEntity() instanceof PlayerEntity) {
                ((PlayerEntity)this.performer.getEntity()).func_191521_c(this.oldMagazineStack);
            }
        }
    }
}

