/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.action;

import com.craftingdead.core.action.AbstractAction;
import com.craftingdead.core.action.ActionType;
import com.craftingdead.core.living.ILiving;
import javax.annotation.Nullable;

public abstract class TimedAction
extends AbstractAction {
    private int durationTicks;

    public TimedAction(ActionType<?> actionType, ILiving<?, ?> performer, @Nullable ILiving<?, ?> target) {
        super(actionType, performer, target);
    }

    protected abstract int getTotalDurationTicks();

    @Override
    public boolean start() {
        if (this.getTotalDurationTicks() <= 0) {
            this.finish();
            return false;
        }
        return true;
    }

    @Override
    public boolean tick() {
        if (++this.durationTicks >= this.getTotalDurationTicks()) {
            this.finish();
            return true;
        }
        return false;
    }

    protected abstract void finish();

    @Override
    public void cancel() {
        this.durationTicks = 0;
    }

    @Override
    public float getProgress(float partialTicks) {
        return ((float)this.durationTicks + partialTicks) / (float)this.getTotalDurationTicks();
    }
}

