/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.action.item;

import com.craftingdead.core.action.item.AbstractActionEntry;
import com.craftingdead.core.living.ILiving;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.ForgeMod;

public class BlockActionEntry
extends AbstractActionEntry<Properties> {
    private final Predicate<BlockState> predicate;
    private BlockPos blockPosTarget;
    private BlockState blockStateTarget;

    public BlockActionEntry(Properties properties) {
        super(properties);
        this.predicate = properties.predicate;
    }

    @Override
    public boolean canPerform(ILiving<?, ?> performer, @Nullable ILiving<?, ?> target, ItemStack heldStack) {
        ModifiableAttributeInstance reachDistanceAttribute = performer.getEntity().func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        RayTraceResult result = performer.getEntity().func_213324_a(reachDistanceAttribute == null ? 4.0 : reachDistanceAttribute.func_111126_e(), 1.0f, true);
        if (result instanceof BlockRayTraceResult) {
            BlockPos blockPos = ((BlockRayTraceResult)result).func_216350_a();
            BlockState blockState = performer.getEntity().func_130014_f_().func_180495_p(blockPos);
            if (this.blockPosTarget == null || this.blockStateTarget == null) {
                this.blockPosTarget = blockPos;
                this.blockStateTarget = blockState;
                if (!this.predicate.test(this.blockStateTarget)) {
                    return false;
                }
            }
            return this.blockPosTarget.equals((Object)blockPos) && this.blockStateTarget.equals(blockState);
        }
        return false;
    }

    @Override
    public boolean finish(ILiving<?, ?> performer, ILiving<?, ?> target, ItemStack heldStack) {
        return true;
    }

    public static class Properties
    extends AbstractActionEntry.Properties<Properties> {
        private Predicate<BlockState> predicate;

        public Properties setPredicate(Predicate<BlockState> predicate) {
            this.predicate = predicate;
            return this;
        }
    }
}

