/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.action.item;

import com.craftingdead.core.action.item.AbstractActionEntry;
import com.craftingdead.core.action.item.UseItemAction;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.util.RayTraceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.EntityRayTraceResult;
import org.apache.commons.lang3.tuple.Pair;

public class EntityActionEntry
extends AbstractActionEntry<Properties> {
    private BiFunction<ILiving<?, ?>, ILiving<?, ?>, ILiving<?, ?>> targetSelector = TargetSelector.SELF_ONLY;
    private final List<Pair<EffectInstance, Float>> effects;
    @Nullable
    private final Pair<Consumer<ILiving<?, ?>>, Float> customAction;
    private ILiving<?, ?> selectedTarget;

    public EntityActionEntry(Properties properties) {
        super(properties);
        this.targetSelector = properties.targetSelector;
        this.effects = properties.effects;
        this.customAction = properties.customAction;
    }

    @Override
    public boolean canPerform(ILiving<?, ?> performer, @Nullable ILiving<?, ?> target, ItemStack heldStack) {
        if (this.selectedTarget == null) {
            this.selectedTarget = this.targetSelector.apply(performer, target);
            if (this.selectedTarget == null) {
                return false;
            }
        }
        if (!performer.getEntity().func_130014_f_().func_201670_d()) {
            Optional<EntityRayTraceResult> entityRayTraceResult = RayTraceUtil.rayTraceEntities(performer.getEntity());
            if (this.selectedTarget != performer && this.selectedTarget.getEntity() != entityRayTraceResult.map(EntityRayTraceResult::func_216348_a).orElse(null)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean finish(ILiving<?, ?> performer, @Nullable ILiving<?, ?> target, ItemStack heldStack) {
        if (this.customAction != null && UseItemAction.random.nextFloat() < ((Float)this.customAction.getRight()).floatValue()) {
            ((Consumer)this.customAction.getLeft()).accept(this.selectedTarget);
        }
        this.selectedTarget.getEntity().curePotionEffects(heldStack);
        for (Pair<EffectInstance, Float> pair : this.effects) {
            if (pair.getLeft() == null || !(UseItemAction.random.nextFloat() < ((Float)pair.getRight()).floatValue())) continue;
            EffectInstance effectInstance = (EffectInstance)pair.getLeft();
            if (effectInstance.func_188419_a().func_76403_b()) {
                effectInstance.func_188419_a().func_180793_a(this.selectedTarget.getEntity(), this.selectedTarget.getEntity(), this.selectedTarget.getEntity(), effectInstance.func_76458_c(), 1.0);
                continue;
            }
            this.selectedTarget.getEntity().func_195064_c(new EffectInstance(effectInstance));
        }
        return true;
    }

    public static enum TargetSelector implements BiFunction<ILiving<?, ?>, ILiving<?, ?>, ILiving<?, ?>>
    {
        SELF_ONLY((performer, target) -> performer),
        OTHERS_ONLY((performer, target) -> target),
        SELF_AND_OTHERS((performer, target) -> target == null ? performer : target);

        private final BiFunction<ILiving<?, ?>, ILiving<?, ?>, ILiving<?, ?>> targetGetter;

        private TargetSelector(BiFunction<ILiving<?, ?>, ILiving<?, ?>, ILiving<?, ?>> targetGetter) {
            this.targetGetter = targetGetter;
        }

        @Override
        public ILiving<?, ?> apply(ILiving<?, ?> performer, @Nullable ILiving<?, ?> target) {
            return this.targetGetter.apply(performer, target);
        }

        public BiFunction<ILiving<?, ?>, ILiving<?, ?>, ILiving<?, ?>> ofType(EntityType<?> entityType) {
            return this.andThen(target -> target.getEntity().func_200600_R() == entityType ? target : null);
        }

        public BiFunction<ILiving<?, ?>, ILiving<?, ?>, ILiving<?, ?>> ofType(Class<? extends LivingEntity> entityType) {
            return this.andThen(target -> target != null && entityType.isAssignableFrom(target.getEntity().getClass()) ? target : null);
        }
    }

    public static class Properties
    extends AbstractActionEntry.Properties<Properties> {
        private BiFunction<ILiving<?, ?>, ILiving<?, ?>, ILiving<?, ?>> targetSelector = TargetSelector.SELF_ONLY;
        private final List<Pair<EffectInstance, Float>> effects = new ArrayList<Pair<EffectInstance, Float>>();
        @Nullable
        private Pair<Consumer<ILiving<?, ?>>, Float> customAction;

        public Properties setTargetSelector(BiFunction<ILiving<?, ?>, ILiving<?, ?>, ILiving<?, ?>> targetSelector) {
            this.targetSelector = targetSelector;
            return this;
        }

        public Properties addEffect(Pair<EffectInstance, Float> effect) {
            this.effects.add(effect);
            return this;
        }

        public Properties setCustomAction(Pair<Consumer<ILiving<?, ?>>, Float> customAction) {
            this.customAction = customAction;
            return this;
        }
    }
}

