/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.action.item;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.action.ActionType;
import com.craftingdead.core.action.TimedAction;
import com.craftingdead.core.action.item.IActionEntry;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.living.ILiving;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public class UseItemAction
extends TimedAction {
    protected static final Random random = new Random();
    private final List<IActionEntry> entries;
    private final boolean freezeMovement;
    private final int totalDurationTicks;
    private final Predicate<Item> heldItemPredicate;
    private IActionEntry selectedEntry;

    private UseItemAction(ActionType<?> actionType, ILiving<?, ?> performer, ILiving<?, ?> target, List<IActionEntry> entries, boolean freezeMovement, int totalDurationTicks, Predicate<Item> heldItemPredicate) {
        super(actionType, performer, target);
        this.entries = entries;
        this.freezeMovement = freezeMovement;
        this.totalDurationTicks = totalDurationTicks;
        this.heldItemPredicate = heldItemPredicate;
    }

    public static Builder builder(ActionType<?> actionType, ILiving<?, ?> performer, ILiving<?, ?> target) {
        return new Builder(actionType, performer, target);
    }

    @Override
    public boolean start() {
        ItemStack heldStack = this.performer.getEntity().func_184614_ca();
        if (this.heldItemPredicate.test(heldStack.func_77973_b())) {
            for (IActionEntry entry : this.entries) {
                if (!entry.canPerform(this.performer, this.target, heldStack)) continue;
                this.selectedEntry = entry;
                return super.start();
            }
        }
        return false;
    }

    @Override
    protected final void finish() {
        ItemStack heldStack = this.performer.getEntity().func_184614_ca();
        if (this.selectedEntry.finish(this.performer, this.target, heldStack)) {
            PlayerEntity playerEntity;
            boolean shrinkStack = this.selectedEntry.shouldShrinkStack(this.performer);
            ItemStack resultStack = new ItemStack(this.selectedEntry.getReturnItem(this.performer));
            PlayerEntity playerEntity2 = playerEntity = this.performer.getEntity() instanceof PlayerEntity ? (PlayerEntity)this.performer.getEntity() : null;
            if (shrinkStack && (playerEntity == null || !playerEntity.func_184812_l_())) {
                heldStack.func_190918_g(1);
            }
            if (!resultStack.func_190926_b()) {
                if (heldStack.func_190926_b()) {
                    this.performer.getEntity().func_184611_a(Hand.MAIN_HAND, resultStack);
                } else if (playerEntity != null && playerEntity.field_71071_by.func_70441_a(resultStack)) {
                    this.performer.getEntity().func_199701_a_(resultStack);
                }
            }
            if (this.selectedEntry.getFinishSound() != null) {
                this.performer.getEntity().func_184185_a(this.selectedEntry.getFinishSound(), 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean tick() {
        boolean finished = super.tick();
        ItemStack heldStack = this.performer.getEntity().func_184614_ca();
        boolean usingItem = true;
        if (((LivingEntity)this.performer.getEntity()).field_70170_p.func_201670_d()) {
            ClientDist clientDist = CraftingDead.getInstance().getClientDist();
            boolean bl = usingItem = !clientDist.isLocalPlayer((Entity)this.performer.getEntity()) || clientDist.isRightMouseDown();
        }
        if (!this.selectedEntry.canPerform(this.performer, this.target, heldStack) || !usingItem) {
            this.performer.cancelAction(true);
        }
        if (this.freezeMovement) {
            if (this.target != null) {
                this.target.setMovementBlocked(true);
            }
            this.performer.setMovementBlocked(true);
        }
        return finished;
    }

    @Override
    protected int getTotalDurationTicks() {
        return this.totalDurationTicks;
    }

    public static class Builder {
        private final ActionType<?> actionType;
        private final ILiving<?, ?> performer;
        private final ILiving<?, ?> target;
        private final List<IActionEntry> entries = new ArrayList<IActionEntry>();
        private boolean freezeMovement;
        private int totalDurationTicks = 32;
        private Predicate<Item> heldItemPredicate;

        public Builder(ActionType<?> actionType, ILiving<?, ?> performer, ILiving<?, ?> target) {
            this.actionType = actionType;
            this.performer = performer;
            this.target = target;
        }

        public Builder addEntry(IActionEntry entry) {
            return this.addEntry(entry, () -> true);
        }

        public Builder addEntry(IActionEntry entry, Supplier<Boolean> condition) {
            if (condition.get().booleanValue() && !this.entries.contains(entry)) {
                this.entries.add(entry);
            }
            return this;
        }

        public Builder setFreezeMovement(boolean freezeMovement) {
            this.freezeMovement = freezeMovement;
            return this;
        }

        public Builder setTotalDurationTicks(int totalDurationTicks) {
            this.totalDurationTicks = totalDurationTicks;
            return this;
        }

        public Builder setHeldItemPredicate(Predicate<Item> heldItemPredicate) {
            this.heldItemPredicate = heldItemPredicate;
            return this;
        }

        public UseItemAction build() {
            return new UseItemAction(this.actionType, this.performer, this.target, this.entries, this.freezeMovement, this.totalDurationTicks, this.heldItemPredicate);
        }
    }
}

