/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.action.reload;

import com.craftingdead.core.action.ActionType;
import com.craftingdead.core.action.TimedAction;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.item.animation.gun.AnimationType;
import com.craftingdead.core.item.animation.gun.GunAnimation;
import com.craftingdead.core.item.animation.gun.reload.GunAnimationReload;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.living.ILiving;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;

public abstract class AbstractReloadAction
extends TimedAction {
    protected final ItemStack gunStack;
    protected final IGun gun;
    protected final ItemStack oldMagazineStack;

    public AbstractReloadAction(ActionType<?> actionType, ILiving<?, ?> performer) {
        super(actionType, performer, null);
        this.gunStack = performer.getEntity().func_184614_ca();
        this.gun = (IGun)this.gunStack.getCapability(ModCapabilities.GUN).orElseThrow(() -> new IllegalStateException("Performer not holding gun"));
        this.oldMagazineStack = this.gun.getAmmoProvider().getMagazineStack();
    }

    @Override
    protected int getTotalDurationTicks() {
        return this.gun.getReloadDurationTicks();
    }

    @Override
    public boolean start() {
        if (this.getPerformer().getEntity().func_70051_ag()) {
            return false;
        }
        if (this.gun.isPerformingRightMouseAction()) {
            this.gun.setPerformingRightMouseAction(this.getPerformer(), false, false);
        }
        this.gun.getReloadSound().ifPresent(sound -> this.performer.getEntity().func_130014_f_().func_217384_a(null, this.performer.getEntity(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f));
        if (this.performer.getEntity().func_130014_f_().func_201670_d()) {
            if (this.oldMagazineStack.func_190926_b()) {
                this.playLoadAnimation(false, null);
            } else {
                this.playLoadAnimation(true, () -> this.playLoadAnimation(false, null));
            }
        }
        return true;
    }

    protected abstract void loadNewMagazineStack(boolean var1);

    private void playLoadAnimation(boolean unload, @Nullable Runnable callback) {
        if (!unload) {
            this.loadNewMagazineStack(true);
        }
        this.gun.getAnimation(AnimationType.RELOAD).filter(animation -> animation instanceof GunAnimationReload).map(animation -> (GunAnimationReload)animation).ifPresent(animation -> {
            animation.setEjectingClip(unload);
            this.gun.getClient().getAnimationController().addAnimation((GunAnimation)animation, callback);
        });
    }

    @Override
    public boolean tick() {
        if (!this.getPerformer().getEntity().func_130014_f_().func_201670_d() && this.getPerformer().getEntity().func_70051_ag()) {
            this.getPerformer().cancelAction(true);
            return false;
        }
        return super.tick();
    }

    @Override
    protected void finish() {
        if (this.performer.getEntity().func_130014_f_().func_201670_d()) {
            return;
        }
        this.loadNewMagazineStack(false);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.gun.getClient() != null) {
            if (this.gun.getReloadSound().isPresent()) {
                Minecraft.func_71410_x().func_147118_V().func_195478_a(this.gun.getReloadSound().get().getRegistryName(), SoundCategory.PLAYERS);
            }
            this.gun.getClient().getAnimationController().removeCurrentAnimation();
        }
        this.revert();
    }

    protected abstract void revert();
}

