/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.action.reload;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.action.ActionType;
import com.craftingdead.core.action.ActionTypes;
import com.craftingdead.core.action.reload.AbstractReloadAction;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.event.CollectMagazineItemHandlers;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.item.gun.ammoprovider.IAmmoProvider;
import com.craftingdead.core.item.gun.ammoprovider.MagazineAmmoProvider;
import com.craftingdead.core.item.gun.magazine.IMagazine;
import com.craftingdead.core.living.ILiving;
import com.google.common.collect.ImmutableList;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class MagazineReloadAction
extends AbstractReloadAction {
    private final MagazineAmmoProvider ammoProvider;
    private ItemStack newMagazineStack;
    private MagazineLocation magazineLocation;

    public MagazineReloadAction(ILiving<?, ?> performer) {
        super((ActionType)ActionTypes.MAGAZINE_RELOAD.get(), performer);
        IAmmoProvider ammoProvider = this.gun.getAmmoProvider();
        if (!(ammoProvider instanceof MagazineAmmoProvider)) {
            throw new IllegalStateException("No MagazineAmmoProvider present");
        }
        this.ammoProvider = (MagazineAmmoProvider)ammoProvider;
    }

    @Override
    public boolean start() {
        Optional<MagazineLocation> result = this.findMagazine(this.performer);
        if (!result.isPresent()) {
            return false;
        }
        this.magazineLocation = result.get();
        this.newMagazineStack = this.magazineLocation.itemHandler.extractItem(this.magazineLocation.slot, 1, false);
        return super.start();
    }

    @Override
    protected void loadNewMagazineStack(boolean displayOnly) {
        this.ammoProvider.setMagazineStack(this.newMagazineStack);
        if (!displayOnly && !this.oldMagazineStack.func_190926_b() && this.performer.getEntity() instanceof PlayerEntity) {
            ((PlayerEntity)this.performer.getEntity()).func_191521_c(this.oldMagazineStack);
        }
    }

    @Override
    protected void revert() {
        this.ammoProvider.setMagazineStack(this.oldMagazineStack);
        ItemStack remainingStack = this.magazineLocation.itemHandler.insertItem(this.magazineLocation.slot, this.newMagazineStack, false);
        this.performer.getEntity().func_199701_a_(remainingStack);
    }

    private List<IItemHandler> collectItemHandlers(ILiving<?, ?> living) {
        PlayerEntity playerEntity;
        TravelersBackpackInventory backpackInventory;
        ImmutableList.Builder builder = ImmutableList.builder();
        CollectMagazineItemHandlers event = new CollectMagazineItemHandlers(living);
        MinecraftForge.EVENT_BUS.post((Event)event);
        builder.addAll(event.getItemHandlers());
        living.getItemHandler().getStackInSlot(InventorySlotType.VEST.getIndex()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        if (CraftingDead.getInstance().isTravelersBackpacksLoaded() && living.getEntity() instanceof PlayerEntity && (backpackInventory = CapabilityUtils.getBackpackInv((PlayerEntity)(playerEntity = (PlayerEntity)living.getEntity()))) != null) {
            builder.add((Object)backpackInventory.getInventory());
        }
        living.getEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private Optional<MagazineLocation> findMagazine(ILiving<?, ?> living) {
        for (IItemHandler itemHandler : this.collectItemHandlers(living)) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (!this.gun.getAcceptedMagazines().contains(itemStack.func_77973_b()) || itemStack.getCapability(ModCapabilities.MAGAZINE).map(IMagazine::isEmpty).orElse(true).booleanValue()) continue;
                return Optional.of(new MagazineLocation(itemHandler, i));
            }
        }
        return Optional.empty();
    }

    private static class MagazineLocation {
        private final IItemHandler itemHandler;
        private final int slot;

        public MagazineLocation(IItemHandler itemHandler, int slot) {
            this.itemHandler = itemHandler;
            this.slot = slot;
        }
    }
}

