/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.capability;

import com.craftingdead.core.capability.EmptyStorage;
import com.craftingdead.core.clothing.DefaultClothing;
import com.craftingdead.core.clothing.IClothing;
import com.craftingdead.core.hat.DefaultHat;
import com.craftingdead.core.hat.IHat;
import com.craftingdead.core.item.animation.DefaultAnimationProvider;
import com.craftingdead.core.item.animation.IAnimationProvider;
import com.craftingdead.core.item.combatslot.ICombatSlotProvider;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.item.gun.magazine.IMagazine;
import com.craftingdead.core.item.gun.magazine.MagazineImpl;
import com.craftingdead.core.item.gun.paint.DefaultPaint;
import com.craftingdead.core.item.gun.paint.IPaint;
import com.craftingdead.core.item.hydration.DefaultHydration;
import com.craftingdead.core.item.hydration.IHydration;
import com.craftingdead.core.item.scope.IScope;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.living.LivingImpl;
import com.craftingdead.core.storage.DefaultStorage;
import com.craftingdead.core.storage.IStorage;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ModCapabilities {
    @CapabilityInject(value=ILiving.class)
    public static final Capability<ILiving<?, ?>> LIVING = null;
    @CapabilityInject(value=IStorage.class)
    public static final Capability<IStorage> STORAGE = null;
    @CapabilityInject(value=IHydration.class)
    public static final Capability<IHydration> HYDRATION = null;
    @CapabilityInject(value=IClothing.class)
    public static final Capability<IClothing> CLOTHING = null;
    @CapabilityInject(value=IHat.class)
    public static final Capability<IHat> HAT = null;
    @CapabilityInject(value=IAnimationProvider.class)
    public static final Capability<IAnimationProvider<?>> ANIMATION_PROVIDER = null;
    @CapabilityInject(value=IGun.class)
    public static final Capability<IGun> GUN = null;
    @CapabilityInject(value=IPaint.class)
    public static final Capability<IPaint> PAINT = null;
    @CapabilityInject(value=IScope.class)
    public static final Capability<IScope> SCOPE = null;
    @CapabilityInject(value=ICombatSlotProvider.class)
    public static final Capability<ICombatSlotProvider> COMBAT_SLOT_PROVIDER = null;
    @CapabilityInject(value=IMagazine.class)
    public static final Capability<IMagazine> MAGAZINE = null;

    public static <T> T unsupported() {
        throw new UnsupportedOperationException();
    }

    public static <T, R extends T> R getExpected(Capability<T> capability, ICapabilityProvider provider, Class<R> clazz) {
        return (R)provider.getCapability(capability).filter(clazz::isInstance).map(clazz::cast).orElseThrow(() -> new IllegalStateException("Expecting capability: " + capability.getName()));
    }

    static {
        CapabilityManager.INSTANCE.register(ILiving.class, new EmptyStorage(), LivingImpl::new);
        CapabilityManager.INSTANCE.register(IStorage.class, new EmptyStorage(), DefaultStorage::new);
        CapabilityManager.INSTANCE.register(IHydration.class, new EmptyStorage(), DefaultHydration::new);
        CapabilityManager.INSTANCE.register(IClothing.class, new EmptyStorage(), DefaultClothing::new);
        CapabilityManager.INSTANCE.register(IHat.class, new EmptyStorage(), DefaultHat::new);
        CapabilityManager.INSTANCE.register(IAnimationProvider.class, new EmptyStorage(), DefaultAnimationProvider::new);
        CapabilityManager.INSTANCE.register(ICombatSlotProvider.class, new EmptyStorage(), ModCapabilities::unsupported);
        CapabilityManager.INSTANCE.register(IGun.class, EmptyStorage.getInstance(), ModCapabilities::unsupported);
        CapabilityManager.INSTANCE.register(IPaint.class, EmptyStorage.getInstance(), DefaultPaint::new);
        CapabilityManager.INSTANCE.register(IMagazine.class, EmptyStorage.getInstance(), MagazineImpl::new);
        CapabilityManager.INSTANCE.register(IScope.class, new EmptyStorage(), ModCapabilities::unsupported);
    }
}

