/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client;

import com.craftingdead.core.IModDist;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.client.ClientConfig;
import com.craftingdead.core.client.audio.EffectsManager;
import com.craftingdead.core.client.crosshair.CrosshairManager;
import com.craftingdead.core.client.gui.IngameGui;
import com.craftingdead.core.client.gui.screen.inventory.EquipmentScreen;
import com.craftingdead.core.client.gui.screen.inventory.GenericContainerScreen;
import com.craftingdead.core.client.particle.GrenadeSmokeParticle;
import com.craftingdead.core.client.particle.RGBFlashParticle;
import com.craftingdead.core.client.renderer.CameraManager;
import com.craftingdead.core.client.renderer.entity.SupplyDropRenderer;
import com.craftingdead.core.client.renderer.entity.grenade.C4ExplosiveRenderer;
import com.craftingdead.core.client.renderer.entity.grenade.CylinderGrenadeRenderer;
import com.craftingdead.core.client.renderer.entity.grenade.FragGrenadeRenderer;
import com.craftingdead.core.client.renderer.entity.grenade.SlimGrenadeRenderer;
import com.craftingdead.core.client.renderer.entity.layer.ClothingLayer;
import com.craftingdead.core.client.renderer.entity.layer.EquipmentLayer;
import com.craftingdead.core.client.renderer.item.ItemRendererManager;
import com.craftingdead.core.client.tutorial.IModTutorialStep;
import com.craftingdead.core.client.tutorial.ModTutorialSteps;
import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.entity.ModEntityTypes;
import com.craftingdead.core.entity.grenade.FlashGrenadeEntity;
import com.craftingdead.core.event.RenderArmClothingEvent;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.inventory.container.ModContainerTypes;
import com.craftingdead.core.item.GunItem;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.item.PaintItem;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.item.gun.paint.IPaint;
import com.craftingdead.core.item.scope.IScope;
import com.craftingdead.core.living.ILiving;
import com.craftingdead.core.living.IPlayer;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.OpenModInventoryMessage;
import com.craftingdead.core.particle.ModParticleTypes;
import com.craftingdead.core.potion.ModEffects;
import com.craftingdead.core.util.ArbitraryTooltips;
import com.craftingdead.core.util.MutableVector2f;
import com.craftingdead.core.util.Text;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class ClientDist
implements IModDist {
    public static final KeyBinding RELOAD = new KeyBinding("key.reload", 82, "key.categories.gameplay");
    public static final KeyBinding REMOVE_MAGAZINE = new KeyBinding("key.remove_magazine", 74, "key.categories.gameplay");
    public static final KeyBinding TOGGLE_FIRE_MODE = new KeyBinding("key.toggle_fire_mode", 86, "key.categories.gameplay");
    public static final KeyBinding OPEN_EQUIPMENT_MENU = new KeyBinding("key.equipment_menu", 90, "key.categories.inventory");
    public static final KeyBinding TOGGLE_COMBAT_MODE = new KeyBinding("key.toggle_combat_mode", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, InputMappings.Type.KEYSYM.func_197944_a(67), "key.categories.inventory");
    public static final ClientConfig clientConfig;
    public static final ForgeConfigSpec clientConfigSpec;
    private static final ResourceLocation ADRENALINE_SHADER;
    private static final Vector3f CAMERA_ROTATIONS;
    private static final MutableVector2f FOV;
    private static final int DOUBLE_CLICK_DURATION = 500;
    private final Minecraft minecraft;
    private final CrosshairManager crosshairManager;
    private final IngameGui ingameGui;
    private final ItemRendererManager itemRendererManager;
    private final CameraManager cameraManager;
    private EffectsManager effectsManager;
    private TutorialSteps lastTutorialStep;
    private long adrenalineShaderStartTime = 0L;
    private float lastTime = 0.0f;
    private boolean wasAdrenalineActive;
    private float lastFov;
    private float fov;
    private boolean wasSneaking;
    private long lastSneakPressTime;

    public ClientDist() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::handleModelRegistry);
        modBus.addListener(this::handleModelBake);
        modBus.addListener(this::handleClientSetup);
        modBus.addListener(this::handleParticleFactoryRegisterEvent);
        modBus.addListener(this::handleItemColor);
        modBus.addListener(this::handleTextureStitch);
        modBus.addListener(this::handleSoundLoad);
        modBus.addListener(this::handleConfigReloading);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientConfigSpec);
        this.minecraft = Minecraft.func_71410_x();
        this.crosshairManager = new CrosshairManager();
        if (this.minecraft != null) {
            ((IReloadableResourceManager)this.minecraft.func_195551_G()).func_219534_a((IFutureReloadListener)this.crosshairManager);
        }
        this.ingameGui = new IngameGui(this.minecraft, this, new ResourceLocation((String)ClientDist.clientConfig.crosshair.get()));
        this.itemRendererManager = new ItemRendererManager();
        this.cameraManager = new CameraManager();
    }

    public void setTutorialStep(ModTutorialSteps step) {
        ClientDist.clientConfig.tutorialStep.set((Object)step);
        Tutorial tutorial = this.minecraft.func_193032_ao();
        tutorial.func_193292_a(TutorialSteps.NONE);
        tutorial.field_193305_b = step.create(this);
    }

    public CrosshairManager getCrosshairManager() {
        return this.crosshairManager;
    }

    public IngameGui getIngameGui() {
        return this.ingameGui;
    }

    public CameraManager getCameraManager() {
        return this.cameraManager;
    }

    public ItemRendererManager getItemRendererManager() {
        return this.itemRendererManager;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public Optional<IPlayer<ClientPlayerEntity>> getPlayer() {
        return Optional.ofNullable(this.minecraft.field_71439_g).flatMap(p -> p.getCapability(ModCapabilities.LIVING).resolve()).filter(living -> living instanceof IPlayer).map(living -> (IPlayer)living);
    }

    public IPlayer<ClientPlayerEntity> getExpectedPlayer() {
        return ModCapabilities.getExpected(ModCapabilities.LIVING, (ICapabilityProvider)this.minecraft.field_71439_g, IPlayer.class);
    }

    public boolean isRightMouseDown() {
        return this.minecraft.field_71474_y.field_74313_G.func_151470_d();
    }

    public boolean isLocalPlayer(Entity entity) {
        return entity == this.minecraft.field_71439_g;
    }

    @SubscribeEvent
    public void handleSoundLoad(SoundLoadEvent event) {
        this.effectsManager = new EffectsManager(event.getManager());
    }

    private void handleConfigReloading(ModConfig.Reloading event) {
        if (event.getConfig().getSpec() == clientConfigSpec) {
            this.ingameGui.setCrosshairLocation(new ResourceLocation((String)ClientDist.clientConfig.crosshair.get()));
        }
    }

    private void handleModelRegistry(ModelRegistryEvent event) {
        StartupMessageManager.addModMessage((String)"Gathering item renderers");
        this.itemRendererManager.gatherItemRenderers();
        StartupMessageManager.addModMessage((String)"Registering special models");
        this.itemRendererManager.getModelDependencies().forEach(ModelLoader::addSpecialModel);
    }

    private void handleModelBake(ModelBakeEvent event) {
        this.itemRendererManager.refreshCachedModels();
    }

    private void handleClientSetup(FMLClientSetupEvent event) {
        ItemModelsProperties.func_239420_a_((ResourceLocation)new ResourceLocation("wearing"), (itemStack, world, entity) -> entity.getCapability(ModCapabilities.LIVING).filter(living -> living.getItemHandler().getStackInSlot(InventorySlotType.HAT.getIndex()) == itemStack).map(__ -> Float.valueOf(1.0f)).orElse(Float.valueOf(0.0f)).floatValue());
        StartupMessageManager.addModMessage((String)"Registering tooltips");
        ArbitraryTooltips.registerTooltip(ModItems.SCUBA_MASK, (stack, world, tooltipFlags) -> Text.translate("item_lore.clothing_item.water_breathing", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        ArbitraryTooltips.registerTooltip(ModItems.SCUBA_CLOTHING, (stack, world, tooltipFlags) -> Text.translate("item_lore.clothing_item.water_speed", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        StartupMessageManager.addModMessage((String)"Registering container screen factories");
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.EQUIPMENT.get()), EquipmentScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.VEST.get()), GenericContainerScreen::new);
        StartupMessageManager.addModMessage((String)"Registering key bindings");
        ClientRegistry.registerKeyBinding((KeyBinding)TOGGLE_FIRE_MODE);
        ClientRegistry.registerKeyBinding((KeyBinding)RELOAD);
        ClientRegistry.registerKeyBinding((KeyBinding)REMOVE_MAGAZINE);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_EQUIPMENT_MENU);
        ClientRegistry.registerKeyBinding((KeyBinding)TOGGLE_COMBAT_MODE);
        StartupMessageManager.addModMessage((String)"Registering entity renderers");
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.SUPPLY_DROP.get()), SupplyDropRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.C4_EXPLOSIVE.get()), C4ExplosiveRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.FIRE_GRENADE.get()), CylinderGrenadeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.FRAG_GRENADE.get()), FragGrenadeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.PIPE_GRENADE.get()), CylinderGrenadeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.DECOY_GRENADE.get()), SlimGrenadeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.SMOKE_GRENADE.get()), CylinderGrenadeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.FLASH_GRENADE.get()), SlimGrenadeRenderer::new);
        StartupMessageManager.addModMessage((String)"Loading model layers");
        this.registerPlayerLayer(ClothingLayer::new);
        this.registerPlayerLayer(renderer -> new EquipmentLayer.Builder().withRenderer(renderer).withSlot(InventorySlotType.MELEE).withCrouchingOrientation(true).build());
        this.registerPlayerLayer(renderer -> new EquipmentLayer.Builder().withRenderer(renderer).withSlot(InventorySlotType.VEST).withCrouchingOrientation(true).build());
        this.registerPlayerLayer(renderer -> new EquipmentLayer.Builder().withRenderer(renderer).withSlot(InventorySlotType.HAT).withHeadOrientation(true).withArbitraryTransformation(matrix -> matrix.func_227862_a_(-1.0f, -1.0f, 1.0f)).build());
        this.registerPlayerLayer(renderer -> new EquipmentLayer.Builder().withRenderer(renderer).withSlot(InventorySlotType.GUN).withCrouchingOrientation(true).build());
    }

    public void registerPlayerLayer(Function<PlayerRenderer, LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>> function) {
        this.minecraft.func_175598_ae().getSkinMap().forEach((skin, renderer) -> renderer.func_177094_a((LayerRenderer)function.apply((PlayerRenderer)renderer)));
    }

    private void handleParticleFactoryRegisterEvent(ParticleFactoryRegisterEvent event) {
        ParticleManager particleManager = this.minecraft.field_71452_i;
        particleManager.func_215234_a((ParticleType)ModParticleTypes.RGB_FLASH.get(), RGBFlashParticle.Factory::new);
        particleManager.func_215234_a((ParticleType)ModParticleTypes.GRENADE_SMOKE.get(), GrenadeSmokeParticle.Factory::new);
    }

    private void handleItemColor(ColorHandlerEvent.Item event) {
        IItemColor gunColor = (stack, tintIndex) -> stack.getCapability(ModCapabilities.GUN).resolve().flatMap(gunController -> gunController.getPaintStack().getCapability(ModCapabilities.PAINT).resolve().flatMap(IPaint::getColour)).orElse(0xFFFFFF) | 0xFF000000;
        ModItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(item -> item instanceof GunItem).forEach(item -> event.getItemColors().func_199877_a(gunColor, new IItemProvider[]{item}));
        IItemColor paintColor = (stack, tintIndex) -> stack.getCapability(ModCapabilities.PAINT).resolve().flatMap(IPaint::getColour).orElse(Integer.MAX_VALUE);
        ModItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(item -> item instanceof PaintItem).forEach(item -> event.getItemColors().func_199877_a(paintColor, new IItemProvider[]{() -> item}));
    }

    private void handleTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            this.itemRendererManager.getTexturesToStitch().forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }
    }

    @SubscribeEvent
    public void handleTooltipEvent(ItemTooltipEvent event) {
        Collection<ArbitraryTooltips.TooltipFunction> functions = ArbitraryTooltips.getFunctions(event.getItemStack().func_77973_b());
        int lineIndex = 1;
        for (ArbitraryTooltips.TooltipFunction function : functions) {
            World world;
            World world2 = world = event.getEntity() != null ? event.getEntity().field_70170_p : null;
            ITextComponent tooltip = function.createTooltip(event.getItemStack(), world, event.getFlags());
            if (tooltip == null) continue;
            event.getToolTip().add(lineIndex++, tooltip);
        }
    }

    @SubscribeEvent
    public void handleClientTick(TickEvent.ClientTickEvent event) {
        switch (event.phase) {
            case START: {
                this.lastTime = (float)Math.ceil(this.lastTime);
                IPlayer player = this.getPlayer().orElse(null);
                if (player == null) break;
                ItemStack heldStack = ((ClientPlayerEntity)player.getEntity()).func_184614_ca();
                IGun gun = (IGun)heldStack.getCapability(ModCapabilities.GUN).orElse(null);
                boolean worldFocused = !this.minecraft.func_147113_T() && this.minecraft.field_213279_p == null && this.minecraft.field_71462_r == null;
                this.cameraManager.tick();
                if (!worldFocused || ((ClientPlayerEntity)player.getEntity()).func_175149_v()) {
                    if (gun != null) {
                        if (gun.isTriggerPressed()) {
                            gun.setTriggerPressed(player, false, true);
                        }
                        if (gun.isPerformingRightMouseAction()) {
                            gun.setPerformingRightMouseAction(player, false, true);
                        }
                    }
                    return;
                }
                while (TOGGLE_COMBAT_MODE.func_151468_f()) {
                    player.setCombatModeEnabled(!player.isCombatModeEnabled());
                }
                if (gun != null) {
                    while (TOGGLE_FIRE_MODE.func_151468_f()) {
                        gun.toggleFireMode(player, true);
                    }
                    while (RELOAD.func_151468_f()) {
                        gun.getAmmoProvider().reload(player);
                    }
                    while (REMOVE_MAGAZINE.func_151468_f()) {
                        gun.getAmmoProvider().unload(player);
                    }
                }
                if (this.minecraft.field_71439_g.func_225608_bj_() != this.wasSneaking) {
                    if (this.minecraft.field_71439_g.func_225608_bj_()) {
                        long currentTime = Util.func_211177_b();
                        if (currentTime - this.lastSneakPressTime <= 500L) {
                            player.setCrouching(true, true);
                        }
                        this.lastSneakPressTime = Util.func_211177_b();
                    } else {
                        player.setCrouching(false, true);
                    }
                    this.wasSneaking = this.minecraft.field_71439_g.func_225608_bj_();
                }
                while (OPEN_EQUIPMENT_MENU.func_151468_f()) {
                    NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new OpenModInventoryMessage());
                    if (!(this.minecraft.func_193032_ao().field_193305_b instanceof IModTutorialStep)) continue;
                    ((IModTutorialStep)this.minecraft.func_193032_ao().field_193305_b).openModInventory();
                }
                TutorialSteps currentTutorialStep = this.minecraft.field_71474_y.field_193631_S;
                if (this.lastTutorialStep != currentTutorialStep) {
                    if (currentTutorialStep == TutorialSteps.NONE) {
                        this.setTutorialStep((ModTutorialSteps)((Object)ClientDist.clientConfig.tutorialStep.get()));
                    }
                    this.lastTutorialStep = currentTutorialStep;
                }
                if (this.minecraft.field_71439_g.func_70644_a((Effect)ModEffects.ADRENALINE.get())) {
                    this.wasAdrenalineActive = true;
                    this.effectsManager.setHighpassLevels(1.0f, 0.015f);
                    this.effectsManager.setDirectHighpassForAll();
                    break;
                }
                if (!this.wasAdrenalineActive) break;
                this.wasAdrenalineActive = false;
                this.effectsManager.removeFilterForAll();
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleRawMouse(InputEvent.RawMouseEvent event) {
        IPlayer player = this.getPlayer().orElse(null);
        if (player != null && this.minecraft.field_213279_p == null && this.minecraft.field_71462_r == null && !((ClientPlayerEntity)player.getEntity()).func_175149_v()) {
            ItemStack heldStack = ((ClientPlayerEntity)player.getEntity()).func_184614_ca();
            IGun gun = (IGun)heldStack.getCapability(ModCapabilities.GUN).orElse(null);
            if (this.minecraft.field_71474_y.field_74312_F.func_197984_a(event.getButton())) {
                boolean triggerPressed;
                boolean bl = triggerPressed = event.getAction() == 1;
                if (gun != null) {
                    event.setCanceled(true);
                    gun.setTriggerPressed(player, triggerPressed, true);
                }
            } else if (this.minecraft.field_71474_y.field_74313_G.func_197984_a(event.getButton()) && gun != null) {
                switch (gun.getRightMouseActionTriggerType()) {
                    case HOLD: {
                        gun.setPerformingRightMouseAction(player, event.getAction() == 1, true);
                        break;
                    }
                    case CLICK: {
                        if (event.getAction() != 1) break;
                        gun.setPerformingRightMouseAction(player, !gun.isPerformingRightMouseAction(), true);
                        break;
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleRenderLiving(RenderLivingEvent.Pre<?, BipedModel<?>> event) {
        ItemStack heldStack = event.getEntity().func_184614_ca();
        if (event.getRenderer().func_217764_d() instanceof BipedModel && heldStack.func_77973_b() instanceof GunItem) {
            BipedModel model = (BipedModel)event.getRenderer().func_217764_d();
            switch (event.getEntity().func_184591_cq()) {
                case LEFT: {
                    model.field_187075_l = BipedModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case RIGHT: {
                    model.field_187076_m = BipedModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        ILiving player;
        ILiving iLiving = player = this.minecraft.func_175606_aa() instanceof AbstractClientPlayerEntity ? (IPlayer)this.minecraft.func_175606_aa().getCapability(ModCapabilities.LIVING).cast().orElse(null) : null;
        if (player == null) {
            return;
        }
        ItemStack heldStack = ((AbstractClientPlayerEntity)player.getEntity()).func_184614_ca();
        IGun gun = (IGun)heldStack.getCapability(ModCapabilities.GUN).orElse(null);
        switch (event.getType()) {
            case HEALTH: 
            case HOTBAR: 
            case EXPERIENCE: 
            case HEALTHMOUNT: 
            case FOOD: 
            case AIR: 
            case ARMOR: {
                event.setCanceled(player.isCombatModeEnabled());
                break;
            }
            case ALL: {
                this.ingameGui.renderOverlay((IPlayer<AbstractClientPlayerEntity>)player, heldStack, gun, event.getMatrixStack(), event.getWindow().func_198107_o(), event.getWindow().func_198087_p(), event.getPartialTicks());
                break;
            }
            case CROSSHAIRS: {
                boolean isAiming = heldStack.getCapability(ModCapabilities.SCOPE).map(arg_0 -> ClientDist.lambda$handleRenderGameOverlayPre$22((IPlayer)player, arg_0)).orElse(false);
                if (player.isMonitoringAction() || isAiming) {
                    event.setCanceled(true);
                    break;
                }
                if (gun == null) break;
                event.setCanceled(true);
                if (!gun.hasCrosshair()) break;
                this.ingameGui.renderCrosshairs(gun.getAccuracy(player), event.getPartialTicks(), event.getWindow().func_198107_o(), event.getWindow().func_198087_p());
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        this.cameraManager.getCameraRotations((float)event.getRenderPartialTicks(), CAMERA_ROTATIONS);
        event.setPitch(event.getPitch() + CAMERA_ROTATIONS.func_195899_a());
        event.setYaw(event.getYaw() + CAMERA_ROTATIONS.func_195900_b());
        event.setRoll(event.getRoll() + CAMERA_ROTATIONS.func_195902_c());
    }

    @SubscribeEvent
    public void handeFOVUpdate(FOVUpdateEvent event) {
        event.setNewfov(event.getNewfov() + this.cameraManager.getFov(Minecraft.func_71410_x().func_184121_ak()));
    }

    @SubscribeEvent
    public void handeFOVUpdate(EntityViewRenderEvent.FOVModifier event) {
        if (this.minecraft.func_175606_aa() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)this.minecraft.func_175606_aa();
            ItemStack heldStack = livingEntity.func_184614_ca();
            float newFov = heldStack.getCapability(ModCapabilities.SCOPE).filter(scope -> scope.isAiming((Entity)livingEntity)).map(scope -> Float.valueOf(1.0f / scope.getZoomMultiplier((Entity)livingEntity))).orElse(Float.valueOf(1.0f)).floatValue();
            this.lastFov = this.fov;
            this.fov = MathHelper.func_219799_g((float)0.25f, (float)this.fov, (float)newFov);
            event.setFOV(event.getFOV() * (double)MathHelper.func_219799_g((float)this.minecraft.func_184121_ak(), (float)this.lastFov, (float)this.fov));
        }
    }

    @SubscribeEvent
    public void handleRenderTick(TickEvent.RenderTickEvent event) {
        switch (event.phase) {
            case START: {
                if (this.minecraft.field_71439_g == null) break;
                this.cameraManager.getLookRotationDelta(FOV);
                this.minecraft.field_71439_g.func_195049_a((double)FOV.getY(), (double)FOV.getX());
                break;
            }
            case END: {
                if (this.minecraft.field_71439_g == null) break;
                this.updateAdrenalineShader(event.renderTickTime);
                break;
            }
        }
    }

    private void updateAdrenalineShader(float partialTicks) {
        boolean shaderLoaded;
        GameRenderer gameRenderer = this.minecraft.field_71460_t;
        boolean bl = shaderLoaded = gameRenderer.func_147706_e() != null && gameRenderer.func_147706_e().func_148022_b().equals(ADRENALINE_SHADER.toString());
        if (this.minecraft.field_71439_g.func_70644_a((Effect)ModEffects.ADRENALINE.get())) {
            long currentTime = Util.func_211177_b();
            if (this.adrenalineShaderStartTime == 0L) {
                this.adrenalineShaderStartTime = currentTime;
            }
            float progress = MathHelper.func_76131_a((float)(((float)(currentTime - this.adrenalineShaderStartTime) - partialTicks) / 5000.0f), (float)0.0f, (float)1.0f);
            if (!shaderLoaded) {
                if (gameRenderer.func_147706_e() != null) {
                    gameRenderer.func_181022_b();
                }
                gameRenderer.func_175069_a(ADRENALINE_SHADER);
            }
            ShaderGroup shaderGroup = gameRenderer.func_147706_e();
            RenderUtil.updateUniform("Saturation", progress * 0.25f, shaderGroup);
        } else if (shaderLoaded) {
            this.adrenalineShaderStartTime = 0L;
            gameRenderer.func_181022_b();
        }
    }

    @SubscribeEvent
    public void handleGuiOpen(GuiOpenEvent event) {
        if (this.minecraft.field_71462_r instanceof EquipmentScreen && event.getGui() == null && ((EquipmentScreen)this.minecraft.field_71462_r).isTransitioning()) {
            event.setCanceled(true);
        }
    }

    public void checkApplyFlashEffects(FlashGrenadeEntity flashGrenadeEntity) {
        int duration = flashGrenadeEntity.calculateDuration((LivingEntity)this.minecraft.field_71439_g, RenderUtil.isInsideGameFOV(flashGrenadeEntity, false));
        if (duration > 0) {
            EffectInstance flashEffect = new EffectInstance((Effect)ModEffects.FLASH_BLINDNESS.get(), duration);
            ModEffects.applyOrOverrideIfLonger((LivingEntity)this.minecraft.field_71439_g, flashEffect);
        }
    }

    public static void renderArmWithClothing(PlayerRenderer renderer, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, AbstractClientPlayerEntity playerEntity, ModelRenderer armRenderer, ModelRenderer armwearRenderer) {
        ResourceLocation clothingTexture = playerEntity.getCapability(ModCapabilities.LIVING).map(ILiving::getItemHandler).map(itemHandler -> itemHandler.getStackInSlot(InventorySlotType.CLOTHING.getIndex())).flatMap(clothingStack -> clothingStack.getCapability(ModCapabilities.CLOTHING).resolve()).map(clothing -> clothing.getTexture(playerEntity.func_175154_l())).orElse(null);
        RenderArmClothingEvent event = new RenderArmClothingEvent(playerEntity, clothingTexture);
        MinecraftForge.EVENT_BUS.post((Event)event);
        clothingTexture = event.getClothingTexture();
        if (clothingTexture != null) {
            PlayerModel playerModel = (PlayerModel)renderer.func_217764_d();
            playerModel.field_217112_c = 0.0f;
            playerModel.field_228270_o_ = false;
            playerModel.field_205061_a = 0.0f;
            playerModel.func_225597_a_((LivingEntity)playerEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            armRenderer.field_78806_j = true;
            armwearRenderer.field_78806_j = true;
            armRenderer.field_78795_f = 0.0f;
            armRenderer.func_228308_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)clothingTexture)), packedLight, OverlayTexture.field_229196_a_);
            armwearRenderer.field_78795_f = 0.0f;
            armwearRenderer.func_228308_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)clothingTexture)), packedLight, OverlayTexture.field_229196_a_);
        }
    }

    private static /* synthetic */ Boolean lambda$handleRenderGameOverlayPre$22(IPlayer player, IScope scope) {
        return scope.isAiming((Entity)player.getEntity());
    }

    static {
        Pair clientConfigPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        clientConfigSpec = (ForgeConfigSpec)clientConfigPair.getRight();
        clientConfig = (ClientConfig)clientConfigPair.getLeft();
        ADRENALINE_SHADER = new ResourceLocation("craftingdead", "shaders/post/adrenaline.json");
        CAMERA_ROTATIONS = new Vector3f();
        FOV = new MutableVector2f();
    }
}

