/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.audio;

import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;

public class EffectsManager {
    private static final Logger logger = LogManager.getLogger();
    private boolean initialisied = false;
    private final SoundEngine soundEngine;
    private int highpassSend;

    public EffectsManager(SoundEngine soundEngine) {
        this.soundEngine = soundEngine;
    }

    private void checkInit() {
        if (this.initialisied) {
            return;
        }
        long currentContext = ALC10.alcGetCurrentContext();
        long currentDevice = ALC10.alcGetContextsDevice((long)currentContext);
        if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
            logger.warn("EFX extension not found on current device");
            return;
        }
        logger.info("EFX extension recognised");
        this.highpassSend = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)this.highpassSend, (int)32769, (int)2);
        EffectsManager.checkLogError("Failed to generate high-pass send");
        this.initialisied = true;
    }

    public void setHighpassLevels(float highpassGain, float highpassCutoff) {
        this.checkInit();
        EXTEfx.alFilterf((int)this.highpassSend, (int)1, (float)highpassGain);
        EXTEfx.alFilterf((int)this.highpassSend, (int)2, (float)highpassCutoff);
    }

    public void setDirectHighpassForAll() {
        for (ChannelManager.Entry entry : this.soundEngine.field_217942_m.values()) {
            entry.func_217888_a(source -> this.setDirectHighpass(source.field_216441_b));
        }
    }

    public void setDirectHighpass(ISound sound) {
        ChannelManager.Entry entry = (ChannelManager.Entry)this.soundEngine.field_217942_m.get(sound);
        if (entry != null) {
            entry.func_217888_a(source -> this.setDirectHighpass(source.field_216441_b));
        }
    }

    public void setDirectHighpass(int source) {
        AL10.alSourcei((int)source, (int)131077, (int)this.highpassSend);
    }

    public void removeFilterForAll() {
        for (ChannelManager.Entry entry : this.soundEngine.field_217942_m.values()) {
            entry.func_217888_a(source -> this.removeFilter(source.field_216441_b));
        }
    }

    public void removeFilter(int source) {
        this.checkInit();
        AL10.alSourcei((int)source, (int)131077, (int)0);
    }

    private static boolean checkLogError(String errorMessage) {
        String errorName;
        int error = AL10.alGetError();
        if (error == 0) {
            return false;
        }
        switch (error) {
            case 40961: {
                errorName = "AL_INVALID_NAME";
                break;
            }
            case 40962: {
                errorName = "AL_INVALID_ENUM";
                break;
            }
            case 40963: {
                errorName = "AL_INVALID_VALUE";
                break;
            }
            case 40964: {
                errorName = "AL_INVALID_OPERATION";
                break;
            }
            case 40965: {
                errorName = "AL_OUT_OF_MEMORY";
                break;
            }
            default: {
                errorName = Integer.toString(error);
            }
        }
        logger.warn(errorMessage + " OpenAL error " + errorName);
        return true;
    }
}

