/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.crosshair;

import com.craftingdead.core.client.crosshair.Crosshair;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrosshairManager
extends ReloadListener<Map<ResourceLocation, Crosshair>> {
    public static final ResourceLocation DEFAULT_CROSSHAIR = new ResourceLocation("craftingdead", "standard");
    private static final Gson gson = new Gson();
    private static final Logger logger = LogManager.getLogger();
    private final Map<ResourceLocation, Crosshair> loadedCrosshairs = new HashMap<ResourceLocation, Crosshair>();

    public Crosshair getCrosshair(ResourceLocation crosshairLocation) {
        Crosshair crosshair = this.loadedCrosshairs.get(crosshairLocation);
        return crosshair != null ? crosshair : this.loadedCrosshairs.get(DEFAULT_CROSSHAIR);
    }

    protected Map<ResourceLocation, Crosshair> prepare(IResourceManager resourceManager, IProfiler profiler) {
        ImmutableMap.Builder crosshairs = ImmutableMap.builder();
        for (String domain : resourceManager.func_199001_a()) {
            ResourceLocation fileLocation = new ResourceLocation(domain, "crosshairs.json");
            try {
                resourceManager.func_199004_b(fileLocation).forEach(resource -> {
                    try (InputStreamReader reader = new InputStreamReader(resource.func_199027_b());){
                        ((List)Codec.list(Crosshair.CODEC).parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)gson.fromJson((Reader)reader, JsonElement.class))).getOrThrow(false, message -> logger.warn("Failed to parse {} Reason: ", (Object)fileLocation.toString(), message))).forEach(crosshair -> crosshairs.put((Object)crosshair.getName(), crosshair));
                    }
                    catch (IOException e) {
                        logger.warn("Failed to read {}", (Object)fileLocation.toString(), (Object)e);
                    }
                });
            }
            catch (IOException iOException) {}
        }
        return crosshairs.build();
    }

    protected void apply(Map<ResourceLocation, Crosshair> crosshairs, IResourceManager resourceManager, IProfiler profiler) {
        this.loadedCrosshairs.clear();
        this.loadedCrosshairs.putAll(crosshairs);
    }
}

