/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.gui;

import com.craftingdead.core.client.util.RenderUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class HitMarker {
    private static final int HIT_MARKER_FADE_TIME_MS = 200;
    private static final int HIT_MARKER_SIZE = 12;
    private final Vector3d pos;
    private final Type kill;
    private long fadeStartTimeMs;

    private HitMarker(Vector3d pos, Type kill) {
        this.pos = pos;
        this.kill = kill;
    }

    public boolean render(int width, int height, float partialTicks) {
        if (this.fadeStartTimeMs == 0L) {
            this.fadeStartTimeMs = Util.func_211177_b();
        }
        float zeroToOneFadePct = MathHelper.func_76131_a((float)((float)(Util.func_211177_b() - this.fadeStartTimeMs) / 200.0f), (float)0.0f, (float)1.0f);
        float oneToZeroFadePct = 1.0f - zeroToOneFadePct;
        if (zeroToOneFadePct == 1.0f) {
            return true;
        }
        RenderUtil.projectToPlayerView(this.pos.func_82615_a(), this.pos.func_82617_b(), this.pos.func_82616_c(), partialTicks).ifPresent(pos -> {
            float alpha = (float)(this.kill.colour >> 24 & 0xFF) / 255.0f;
            float red = (float)(this.kill.colour >> 16 & 0xFF) / 255.0f;
            float green = (float)(this.kill.colour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(this.kill.colour & 0xFF) / 255.0f;
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)red, (float)green, (float)blue, (float)(alpha * oneToZeroFadePct));
            RenderSystem.pushMatrix();
            float leastCrossEndPos = 12.0f * oneToZeroFadePct;
            float higherCrossEndPos = leastCrossEndPos * 2.0f;
            float markerSizeMean = (higherCrossEndPos + leastCrossEndPos) / 2.0f;
            RenderSystem.translatef((float)((float)(width / 2) + pos.field_189982_i - markerSizeMean), (float)((float)(height / 2) - pos.field_189983_j - markerSizeMean), (float)0.0f);
            RenderSystem.lineWidth((float)(oneToZeroFadePct * 4.5f));
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            bufferbuilder.func_225582_a_((double)higherCrossEndPos, (double)leastCrossEndPos, 0.0).func_181675_d();
            bufferbuilder.func_225582_a_((double)leastCrossEndPos, (double)higherCrossEndPos, 0.0).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            bufferbuilder.func_225582_a_((double)leastCrossEndPos, (double)leastCrossEndPos, 0.0).func_181675_d();
            bufferbuilder.func_225582_a_((double)higherCrossEndPos, (double)higherCrossEndPos, 0.0).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.popMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        });
        return false;
    }

    public static enum Type {
        HIT(-1),
        KILL(-5043200);

        private final int colour;

        private Type(int colour) {
            this.colour = colour;
        }
    }

    public static enum Mode {
        OFF((pos, kill) -> Optional.empty()),
        KILL((pos, kill) -> kill != false ? Optional.of(new HitMarker((Vector3d)pos, Type.KILL)) : Optional.empty()),
        HIT_AND_KILL((pos, kill) -> Optional.of(new HitMarker((Vector3d)pos, kill != false ? Type.KILL : Type.HIT)));

        private final BiFunction<Vector3d, Boolean, Optional<HitMarker>> factory;

        private Mode(BiFunction<Vector3d, Boolean, Optional<HitMarker>> factory) {
            this.factory = factory;
        }

        public Optional<HitMarker> createHitMarker(Vector3d pos, boolean kill) {
            return this.factory.apply(pos, kill);
        }
    }
}

