/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer;

import com.craftingdead.core.client.renderer.VelocitySmoother;
import com.craftingdead.core.util.MutableVector2f;
import java.util.Random;
import net.minecraft.client.util.NativeUtil;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class CameraManager {
    private static final Random random = new Random();
    private static final float LOOK_ROTATION_DECELERATION = 10.0f;
    private VelocitySmoother lookPitchSmoother = new VelocitySmoother(0.5f);
    private VelocitySmoother lookYawSmoother = new VelocitySmoother(0.5f);
    private float lastLookTime = Float.MIN_VALUE;
    private VelocitySmoother pitchSmoother = new VelocitySmoother(1.0f);
    private float pitch;
    private float lastPitch;
    private VelocitySmoother rollSmoother = new VelocitySmoother(1.0f);
    private float roll;
    private float lastRoll;

    public void joltCamera(float amountPercent, boolean modifyLookPosition) {
        if (amountPercent == 0.0f) {
            return;
        }
        float randomAmount = amountPercent * (random.nextFloat() + 1.0f) / 2.0f;
        float randomNegativeAmount = randomAmount * (random.nextBoolean() ? 1.0f : -1.0f);
        if (modifyLookPosition) {
            this.lookPitchSmoother.add(-randomAmount * 25.0f);
            this.lookYawSmoother.add(randomNegativeAmount * 12.5f);
        }
        this.pitchSmoother.add(-randomAmount * 12.0f);
        this.rollSmoother.add(randomNegativeAmount * 7.5f);
    }

    public void tick() {
        this.lastPitch = this.pitch;
        this.pitch = this.pitchSmoother.getAndDecelerate(0.5f);
        this.lastRoll = this.roll;
        this.roll = this.rollSmoother.getAndDecelerate(0.5f);
    }

    public void getLookRotationDelta(MutableVector2f result) {
        float currentTime = (float)NativeUtil.func_216394_b();
        float timeDelta = currentTime - this.lastLookTime;
        this.lastLookTime = currentTime;
        float deceleration = timeDelta * 10.0f;
        result.set(this.lookPitchSmoother.getAndDecelerate(deceleration), this.lookYawSmoother.getAndDecelerate(deceleration));
    }

    public void getCameraRotations(float partialTicks, Vector3f result) {
        result.func_195905_a(this.lerpPitch(partialTicks), 0.0f, this.lerpRoll(partialTicks));
    }

    public float getFov(float partialTicks) {
        return -this.lerpPitch(partialTicks) * 0.015f;
    }

    private float lerpPitch(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastPitch, (float)this.pitch);
    }

    private float lerpRoll(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastRoll, (float)this.roll);
    }
}

