/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer;

import net.minecraft.util.math.MathHelper;

public class VelocitySmoother {
    private final float acceleration;
    private float targetVelocity;
    private float remainingVelocity;
    private float lastVelocity;

    public VelocitySmoother(float acceleration) {
        this.acceleration = acceleration;
    }

    public void add(float velocity) {
        this.targetVelocity += velocity;
    }

    public void reset() {
        this.targetVelocity = 0.0f;
        this.remainingVelocity = 0.0f;
        this.lastVelocity = 0.0f;
    }

    public float getAndDecelerate(float deceleration) {
        float nextVelocity = this.targetVelocity - this.remainingVelocity;
        float currentVelocity = MathHelper.func_219799_g((float)this.acceleration, (float)this.lastVelocity, (float)nextVelocity);
        float signum = Math.signum(nextVelocity);
        if (signum * nextVelocity > signum * this.lastVelocity) {
            nextVelocity = currentVelocity;
        }
        this.lastVelocity = currentVelocity;
        this.remainingVelocity += nextVelocity * deceleration;
        float result = nextVelocity * deceleration;
        if (Math.abs(result) < 0.01f) {
            result = 0.0f;
            this.reset();
        }
        return result;
    }
}

