/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.entity.layer;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.inventory.InventorySlotType;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;

public class EquipmentLayer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private final InventorySlotType slot;
    private final boolean useCrouchingOrientation;
    private final boolean useHeadOrientation;
    private final Consumer<MatrixStack> transformation;

    private EquipmentLayer(Builder<T, M> builder) {
        super((IEntityRenderer)((Builder)builder).entityRenderer);
        this.slot = ((Builder)builder).slot;
        this.useCrouchingOrientation = ((Builder)builder).useCrouchingOrientation;
        this.transformation = ((Builder)builder).tranformation;
        this.useHeadOrientation = ((Builder)builder).useHeadOrientation;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffers, int packedLight, LivingEntity entity, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        entity.getCapability(ModCapabilities.LIVING).ifPresent(living -> {
            ItemStack itemStack = living.getItemHandler().getStackInSlot(this.slot.getIndex());
            if (!itemStack.func_190926_b()) {
                IBakedModel itemModel = itemRenderer.func_184393_a(itemStack, entity.field_70170_p, entity);
                matrix.func_227860_a_();
                if (this.useCrouchingOrientation && entity.func_213453_ef()) {
                    RenderUtil.applyPlayerCrouchRotation(matrix);
                }
                if (this.useHeadOrientation) {
                    if (entity.func_70631_g_()) {
                        matrix.func_227861_a_(0.0, 0.03125, 0.0);
                        matrix.func_227862_a_(0.7f, 0.7f, 0.7f);
                        matrix.func_227861_a_(0.0, 1.0, 0.0);
                    }
                    ((BipedModel)this.func_215332_c()).func_205072_a().func_228307_a_(matrix);
                }
                if (this.transformation != null) {
                    this.transformation.accept(matrix);
                }
                itemRenderer.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.HEAD, false, matrix, buffers, packedLight, OverlayTexture.field_229196_a_, itemModel);
                matrix.func_227865_b_();
            }
        });
    }

    public static class Builder<T extends LivingEntity, M extends BipedModel<T>> {
        private LivingRenderer<T, M> entityRenderer;
        private InventorySlotType slot;
        private Consumer<MatrixStack> tranformation;
        private boolean useCrouchingOrientation;
        private boolean useHeadOrientation;

        public Builder<T, M> withRenderer(LivingRenderer<T, M> entityRenderer) {
            this.entityRenderer = entityRenderer;
            return this;
        }

        public Builder<T, M> withSlot(InventorySlotType slot) {
            this.slot = slot;
            return this;
        }

        public Builder<T, M> withArbitraryTransformation(Consumer<MatrixStack> transformation) {
            this.tranformation = transformation;
            return this;
        }

        public Builder<T, M> withCrouchingOrientation(boolean useCrouchingOrientation) {
            this.useCrouchingOrientation = useCrouchingOrientation;
            return this;
        }

        public Builder<T, M> withHeadOrientation(boolean useHeadOrientation) {
            this.useHeadOrientation = useHeadOrientation;
            return this;
        }

        public EquipmentLayer<T, M> build() {
            Validate.notNull(this.entityRenderer, (String)"The renderer must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)this.slot), (String)"The slot must not be null", (Object[])new Object[0]);
            return new EquipmentLayer(this);
        }
    }
}

