/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.item;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.client.renderer.item.IItemRenderer;
import com.craftingdead.core.client.renderer.item.model.ModelMuzzleFlash;
import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.item.AttachmentItem;
import com.craftingdead.core.item.MagazineItem;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.item.PaintItem;
import com.craftingdead.core.item.gun.AbstractGunType;
import com.craftingdead.core.item.gun.IGun;
import com.craftingdead.core.item.gun.paint.IPaint;
import com.craftingdead.core.item.scope.IScope;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class GunRenderer
implements IItemRenderer {
    private static final int FLASH_TEXTURE_CHANGE_TIMEOUT_MS = 250;
    private static final int SPRINT_TRANSITION_MS = 200;
    private static final Random random = new Random();
    protected Minecraft minecraft = Minecraft.func_71410_x();
    private final Map<Integer, IBakedModel> cachedModels = new HashMap<Integer, IBakedModel>();
    private final Model muzzleFlashModel = new ModelMuzzleFlash();
    private final ResourceLocation registryName;
    private final AbstractGunType<?> gunType;
    protected float muzzleFlashX = 0.4f;
    protected float muzzleFlashY = 0.2f;
    protected float muzzleFlashZ = -1.8f;
    protected float muzzleScale = 2.0f;
    private long lastFlashTime = 0L;
    private long sprintStartTimeMs;
    private boolean wasSprinting;

    public GunRenderer(ResourceLocation registryName, AbstractGunType<?> gunType) {
        this.registryName = registryName;
        this.gunType = gunType;
    }

    @Override
    public boolean handleRenderType(ItemStack item, ItemCameraTransforms.TransformType transformType) {
        switch (transformType) {
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: 
            case HEAD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void renderGeneric(ItemStack itemStack, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        float partialTicks = this.minecraft.func_147113_T() ? 1.0f : this.minecraft.func_184121_ak();
        IGun gun = (IGun)itemStack.getCapability(ModCapabilities.GUN).orElseThrow(() -> new IllegalArgumentException("Gun expected"));
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.25f, 1.25f, 1.25f);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(3.1f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(3.14f));
        this.applyGenericTransforms(gun, matrixStack);
        this.renderGunModel(itemStack.func_77962_s(), gun, ItemCameraTransforms.TransformType.FIXED, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        this.renderMainGunAmmo(gun, itemStack.func_77962_s(), ItemCameraTransforms.TransformType.FIXED, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        this.renderMainGunAttachments(gun, itemStack.func_77962_s(), ItemCameraTransforms.TransformType.FIXED, partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderItem(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        boolean scopeOverlayActive;
        float partialTicks = this.minecraft.func_147113_T() ? 1.0f : this.minecraft.func_184121_ak();
        IGun gun = (IGun)itemStack.getCapability(ModCapabilities.GUN).orElseThrow(() -> new IllegalArgumentException("Gun expected"));
        boolean bl = scopeOverlayActive = gun instanceof IScope && ((IScope)((Object)gun)).isAiming((Entity)entity) && ((IScope)((Object)gun)).getOverlayTexture((Entity)entity).isPresent();
        if (scopeOverlayActive) {
            return;
        }
        boolean leftHanded = transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
        matrixStack.func_227860_a_();
        this.applyLegacyTransforms(matrixStack, transformType, leftHanded);
        switch (transformType) {
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                if (!(entity instanceof AbstractClientPlayerEntity)) break;
                AbstractClientPlayerEntity playerEntity = (AbstractClientPlayerEntity)entity;
                this.renderFirstPerson(playerEntity, itemStack, gun, transformType, partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                this.renderThirdPerson(entity, itemStack, gun, transformType, partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
                break;
            }
            case HEAD: {
                this.renderOnBack(entity, itemStack.func_77962_s(), gun, partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
                break;
            }
        }
        matrixStack.func_227865_b_();
    }

    private final void applyLegacyTransforms(MatrixStack matrixStack, ItemCameraTransforms.TransformType transformType, boolean leftHanded) {
        boolean thirdPerson;
        boolean bl = thirdPerson = transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
        if (leftHanded && !thirdPerson) {
            matrixStack.func_227861_a_((double)1.12f, 0.0, 0.0);
        }
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        if (thirdPerson) {
            matrixStack.func_227861_a_(-1.0, 0.0, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(50.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(70.0f));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-35.0f));
        }
        if (transformType == ItemCameraTransforms.TransformType.HEAD) {
            matrixStack.func_227861_a_(-1.0, 2.5, 3.75);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(25.0f));
            matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
            matrixStack.func_227861_a_(-2.0, -2.0, -2.0);
        }
        matrixStack.func_227861_a_(0.3125, (double)0.47625f, (double)0.8625f);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(0.0625f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(95.0625f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(335.0f));
        matrixStack.func_227861_a_(-0.9375, -0.0625, 0.0);
    }

    private final void renderFirstPersonArms(AbstractClientPlayerEntity playerEntity, ItemStack itemStack, IGun gun, ItemCameraTransforms.TransformType transformType, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight) {
        PlayerRenderer playerRenderer = (PlayerRenderer)this.minecraft.func_175598_ae().func_78713_a((Entity)playerEntity);
        matrixStack.func_227860_a_();
        gun.getClient().getAnimationController().applyTransforms((LivingEntity)playerEntity, itemStack, "right_hand", transformType, matrixStack, partialTicks);
        this.minecraft.func_110434_K().func_110577_a(playerEntity.func_110306_p());
        matrixStack.func_227861_a_(1.0, 1.0, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(125.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_((double)0.19f, (double)-1.4f, 0.5);
        this.applyHandTransforms(gun, true, matrixStack);
        playerRenderer.func_229144_a_(matrixStack, renderTypeBuffer, packedLight, playerEntity);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        gun.getClient().getAnimationController().applyTransforms((LivingEntity)playerEntity, itemStack, "left_hand", transformType, matrixStack, partialTicks);
        this.minecraft.func_110434_K().func_110577_a(playerEntity.func_110306_p());
        matrixStack.func_227861_a_(1.5, 0.0, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(120.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(120.0f));
        matrixStack.func_227861_a_((double)0.3f, -1.5, (double)-0.12f);
        this.applyHandTransforms(gun, false, matrixStack);
        matrixStack.func_227862_a_(1.0f, 1.2f, 1.0f);
        playerRenderer.func_229146_b_(matrixStack, renderTypeBuffer, packedLight, playerEntity);
        matrixStack.func_227865_b_();
    }

    private void renderFlash(IGun gun, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedOverlay) {
        matrixStack.func_227860_a_();
        long currentTime = Util.func_211177_b();
        long deltaTime = currentTime - this.lastFlashTime;
        if (deltaTime > 250L) {
            this.lastFlashTime = currentTime;
            deltaTime = 250L;
        }
        int texture = (int)(deltaTime / 100L + 1L);
        float scale = (float)(random.nextInt(5) + 3) / 10.0f;
        matrixStack.func_227863_a_(new Vector3f(-0.08f, 1.0f, 0.0f).func_229187_a_(-85.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
        matrixStack.func_227862_a_(this.muzzleScale + scale, this.muzzleScale + scale, this.muzzleScale + scale);
        if (gun.getAttachments().contains(ModItems.SUPPRESSOR.get())) {
            this.muzzleFlashZ = (float)((double)this.muzzleFlashZ - 0.4);
        }
        matrixStack.func_227861_a_((double)(this.muzzleFlashX - scale * this.muzzleFlashX / 2.0f), (double)(this.muzzleFlashY - scale * this.muzzleFlashY / 2.0f), (double)(this.muzzleFlashZ - scale * this.muzzleFlashZ / 2.0f));
        IVertexBuilder flashVertexBuilder = renderTypeBuffer.getBuffer(this.muzzleFlashModel.func_228282_a_(new ResourceLocation("craftingdead", "textures/flash/flash" + texture + ".png")));
        this.muzzleFlashModel.func_225598_a_(matrixStack, flashVertexBuilder, 0xF000F0, packedOverlay, 1.0f, 1.0f, 1.0f, scale + 0.5f);
        matrixStack.func_227865_b_();
    }

    private final void renderFirstPerson(AbstractClientPlayerEntity playerEntity, ItemStack itemStack, IGun gun, ItemCameraTransforms.TransformType transformType, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        boolean aiming = gun instanceof IScope && ((IScope)((Object)gun)).isAiming((Entity)playerEntity);
        boolean flash = gun.getClient().isFlashing();
        if (flash) {
            packedLight = 0xF000F0;
        }
        matrixStack.func_227860_a_();
        if (aiming) {
            this.applyAimingTransforms(gun, matrixStack);
        } else {
            if (!playerEntity.func_70051_ag()) {
                this.renderFirstPersonArms(playerEntity, itemStack, gun, transformType, partialTicks, matrixStack, renderTypeBuffer, packedLight);
            }
            if (flash) {
                this.renderFlash(gun, matrixStack, renderTypeBuffer, packedOverlay);
            }
            this.applyFirstPersonTransforms(gun, matrixStack);
        }
        if (this.wasSprinting != playerEntity.func_70051_ag()) {
            this.sprintStartTimeMs = Util.func_211177_b();
            this.wasSprinting = playerEntity.func_70051_ag();
        }
        float zeroToOneFadePct = MathHelper.func_76131_a((float)((float)(Util.func_211177_b() - this.sprintStartTimeMs) / 200.0f), (float)0.0f, (float)1.0f);
        if (!playerEntity.func_70051_ag()) {
            zeroToOneFadePct = 1.0f - zeroToOneFadePct;
        }
        this.applySprintingTransforms(matrixStack, RenderUtil.easeInOutSine(zeroToOneFadePct));
        gun.getClient().getAnimationController().applyTransforms((LivingEntity)playerEntity, itemStack, "body", transformType, matrixStack, partialTicks);
        this.renderGunModel(itemStack.func_77962_s(), gun, transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.func_227860_a_();
        gun.getClient().getAnimationController().applyTransforms((LivingEntity)playerEntity, itemStack, "magazine", transformType, matrixStack, partialTicks);
        this.renderMainGunAmmo(gun, itemStack.func_77962_s(), transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
        this.renderMainGunAttachments(gun, itemStack.func_77962_s(), transformType, partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    private final void renderThirdPerson(LivingEntity livingEntity, ItemStack itemStack, IGun gun, ItemCameraTransforms.TransformType transformType, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        this.applyThirdPersonTransforms(gun, matrixStack);
        gun.getClient().getAnimationController().applyTransforms(livingEntity, itemStack, "body", transformType, matrixStack, this.minecraft.func_184121_ak());
        this.renderGunModel(itemStack.func_77962_s(), gun, transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        this.renderMainGunAmmo(gun, itemStack.func_77962_s(), transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        this.renderMainGunAttachments(gun, itemStack.func_77962_s(), transformType, partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    public void renderOnBack(LivingEntity entity, boolean glint, IGun gun, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        this.applyWearingTransforms(gun, matrixStack);
        this.renderGunModel(glint, gun, ItemCameraTransforms.TransformType.HEAD, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        this.renderMainGunAmmo(gun, glint, ItemCameraTransforms.TransformType.HEAD, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        this.renderMainGunAttachments(gun, glint, ItemCameraTransforms.TransformType.HEAD, partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    protected final void renderBakedModel(IBakedModel bakedModel, boolean glint, int colour, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.0, (double)-1.45f, 0.0);
        bakedModel = bakedModel.handlePerspective(transformType, matrixStack);
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)Atlases.func_228785_j_(), (boolean)true, (boolean)glint);
        List bakedQuads = bakedModel.getQuads(null, null, random, (IModelData)EmptyModelData.INSTANCE);
        MatrixStack.Entry matrixStackEntry = matrixStack.func_227866_c_();
        for (BakedQuad bakedQuad : bakedQuads) {
            float red = (float)(colour >> 16 & 0xFF) / 255.0f;
            float green = (float)(colour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(colour & 0xFF) / 255.0f;
            vertexBuilder.addVertexData(matrixStackEntry, bakedQuad, red, green, blue, packedLight, packedOverlay, true);
        }
        matrixStack.func_227865_b_();
    }

    private final void renderGunModel(boolean glint, IGun gun, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.05, 0.0);
        IBakedModel bakedModel = this.getBakedModel(this.getGunModelLocation(), gun.getPaint().resolve().flatMap(IPaint::getSkin).map(skin -> ImmutableMap.of((Object)"base", (Object)Either.left((Object)new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation(skin.func_110624_b(), "gun/" + this.registryName.func_110623_a() + "_" + skin.func_110623_a()))))).orElse(null));
        this.renderBakedModel(bakedModel, glint, gun.getPaint().resolve().flatMap(IPaint::getColour).orElse(-1), transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    protected final RenderMaterial getGunMaterial(IGun gun) {
        IUnbakedModel unbakedModel = ModelLoader.instance().getModelOrMissing(this.getGunModelLocation());
        ResourceLocation skin = gun.getPaint().resolve().flatMap(IPaint::getSkin).orElse(null);
        if (unbakedModel instanceof BlockModel) {
            if (skin != null) {
                return new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation(skin.func_110624_b(), "gun/" + this.registryName.func_110623_a() + "_" + skin.func_110623_a()));
            }
            return ((BlockModel)unbakedModel).func_228816_c_("base");
        }
        return new RenderMaterial(PlayerContainer.field_226615_c_, MissingTextureSprite.func_195675_b());
    }

    protected final IBakedModel getBakedModel(ResourceLocation modelLocation, @Nullable Map<String, Either<RenderMaterial, String>> textures) {
        return this.cachedModels.computeIfAbsent(modelLocation.hashCode() + (textures == null ? 0 : textures.hashCode()), key -> {
            IUnbakedModel model;
            if (textures != null && (model = ModelLoader.instance().getModelOrMissing(modelLocation)) instanceof BlockModel) {
                BlockModel blockModel = (BlockModel)model;
                BlockModel overriddenModel = new BlockModel(null, new ArrayList(), textures, false, null, ItemCameraTransforms.field_178357_a, new ArrayList());
                overriddenModel.field_178315_d = blockModel;
                return overriddenModel.func_228813_a_((ModelBakery)ModelLoader.instance(), overriddenModel, ModelLoader.defaultTextureGetter(), (IModelTransform)SimpleModelTransform.IDENTITY, modelLocation, false);
            }
            return this.minecraft.func_209506_al().getModel(modelLocation);
        });
    }

    private void renderMainGunAttachments(IGun gun, boolean glint, ItemCameraTransforms.TransformType transformType, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        if (gun.hasIronSight()) {
            matrixStack.func_227860_a_();
            this.renderAdditionalParts(gun, partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        float scale = 0.1f;
        matrixStack.func_227862_a_(scale, scale, scale);
        for (AttachmentItem attachmentItem : gun.getAttachments()) {
            matrixStack.func_227860_a_();
            this.applyAttachmentTransforms(attachmentItem, matrixStack);
            scale = 10.0f;
            matrixStack.func_227862_a_(scale, scale, scale);
            IBakedModel bakedModel = this.getBakedModel(this.getAttachmentModelLocation(attachmentItem.getRegistryName()), null);
            this.renderBakedModel(bakedModel, glint, gun.getPaint().resolve().flatMap(IPaint::getColour).orElse(-1), transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private void renderMainGunAmmo(IGun gun, boolean glint, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        ItemStack magazineStack = gun.getAmmoProvider().getMagazineStack();
        if (!magazineStack.func_190926_b()) {
            matrixStack.func_227860_a_();
            float scale = 0.1f;
            matrixStack.func_227862_a_(scale, scale, scale);
            this.applyMagazineTransforms(magazineStack, matrixStack);
            scale = 10.0f;
            matrixStack.func_227862_a_(scale, scale, scale);
            ResourceLocation modelLocation = this.getMagazineModelLocation(magazineStack.func_77973_b().getRegistryName());
            IBakedModel magazineBakedModel = gun.getAmmoProvider().getExpectedMagazine().hasCustomTexture() ? this.getBakedModel(modelLocation, null) : this.getBakedModel(modelLocation, (Map<String, Either<RenderMaterial, String>>)ImmutableMap.of((Object)"base", (Object)Either.left((Object)this.getGunMaterial(gun))));
            this.renderBakedModel(magazineBakedModel, glint, gun.getPaint().resolve().flatMap(IPaint::getColour).orElse(-1), transformType, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
            matrixStack.func_227865_b_();
        }
    }

    protected abstract void renderAdditionalParts(IGun var1, float var2, MatrixStack var3, IRenderTypeBuffer var4, int var5, int var6);

    protected abstract void applyGenericTransforms(IGun var1, MatrixStack var2);

    protected abstract void applyThirdPersonTransforms(IGun var1, MatrixStack var2);

    protected abstract void applyFirstPersonTransforms(IGun var1, MatrixStack var2);

    protected abstract void applyAimingTransforms(IGun var1, MatrixStack var2);

    protected abstract void applyWearingTransforms(IGun var1, MatrixStack var2);

    protected abstract void applyMagazineTransforms(ItemStack var1, MatrixStack var2);

    protected abstract void applyAttachmentTransforms(AttachmentItem var1, MatrixStack var2);

    protected abstract void applyHandTransforms(IGun var1, boolean var2, MatrixStack var3);

    protected void applySprintingTransforms(MatrixStack matrixStack, float pct) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(pct * -50.0f));
        matrixStack.func_227861_a_((double)(pct * 0.3f), 0.0, (double)(pct * 0.3f));
    }

    protected ResourceLocation getGunModelLocation() {
        return new ResourceLocation(this.registryName.func_110624_b(), "gun/" + this.registryName.func_110623_a());
    }

    protected ResourceLocation getAttachmentModelLocation(ResourceLocation attachmentName) {
        return new ResourceLocation(attachmentName.func_110624_b(), "attachment/" + attachmentName.func_110623_a());
    }

    protected ResourceLocation getMagazineModelLocation(ResourceLocation magazineName) {
        return new ResourceLocation(magazineName.func_110624_b(), "magazine/" + magazineName.func_110623_a());
    }

    @Override
    public Collection<ResourceLocation> getModelDependencies() {
        HashSet<ResourceLocation> dependencies = new HashSet<ResourceLocation>();
        dependencies.addAll(this.gunType.getAcceptedAttachments().stream().map(ForgeRegistryEntry::getRegistryName).map(this::getAttachmentModelLocation).collect(Collectors.toSet()));
        dependencies.addAll(this.gunType.getAcceptedMagazines().stream().filter(MagazineItem::hasCustomTexture).map(ForgeRegistryEntry::getRegistryName).map(this::getMagazineModelLocation).collect(Collectors.toSet()));
        dependencies.add(this.getGunModelLocation());
        return dependencies;
    }

    @Override
    public Collection<ResourceLocation> getAdditionalModelTextures() {
        HashSet<ResourceLocation> textures = new HashSet<ResourceLocation>();
        textures.addAll(this.gunType.getAcceptedPaints().stream().filter(PaintItem::hasSkin).map(paintItem -> new ResourceLocation(paintItem.getRegistryName().func_110624_b(), "gun/" + this.registryName.func_110623_a() + "_" + paintItem.getRegistryName().func_110623_a())).collect(Collectors.toSet()));
        return textures;
    }

    @Override
    public void refreshCachedModels() {
        this.cachedModels.clear();
    }
}

