/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.item;

import com.craftingdead.core.client.renderer.item.IItemRenderer;
import com.craftingdead.core.client.renderer.item.IRendererProvider;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemRendererManager {
    private static final Logger logger = LogManager.getLogger();
    private final Map<IRegistryDelegate<Item>, IItemRenderer> itemRenderers = new Object2ObjectOpenHashMap();

    public void gatherItemRenderers() {
        logger.debug("Gathering item renderers");
        this.itemRenderers.clear();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (!(item instanceof IRendererProvider)) continue;
            this.itemRenderers.put((IRegistryDelegate<Item>)item.delegate, ((IRendererProvider)item).getRenderer());
        }
    }

    public void refreshCachedModels() {
        StartupMessageManager.addModMessage((String)"Refreshing cached models");
        this.itemRenderers.values().forEach(IItemRenderer::refreshCachedModels);
    }

    public Collection<ResourceLocation> getModelDependencies() {
        return this.itemRenderers.values().stream().flatMap(itemRenderer -> itemRenderer.getModelDependencies().stream()).collect(Collectors.toSet());
    }

    public Collection<ResourceLocation> getTexturesToStitch() {
        return this.itemRenderers.values().stream().flatMap(itemRenderer -> itemRenderer.getAdditionalModelTextures().stream()).collect(Collectors.toSet());
    }

    public Optional<IItemRenderer> getItemRenderer(Item item) {
        return Optional.ofNullable(this.itemRenderers.get(item.delegate));
    }
}

