/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.tutorial;

import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.client.tutorial.CompletedModTutorialStep;
import com.craftingdead.core.client.tutorial.OpenEquipmentMenuStep;
import java.util.function.Function;
import net.minecraft.client.tutorial.ITutorialStep;

public enum ModTutorialSteps {
    OPEN_EQUIPMENT_MENU("open_equipment_menu", OpenEquipmentMenuStep::new),
    NONE("none", CompletedModTutorialStep::new);

    private final String name;
    private final Function<ClientDist, ? extends ITutorialStep> tutorial;

    private <T extends ITutorialStep> ModTutorialSteps(String name, Function<ClientDist, T> tutorial) {
        this.name = name;
        this.tutorial = tutorial;
    }

    public ITutorialStep create(ClientDist client) {
        return this.tutorial.apply(client);
    }

    public String getName() {
        return this.name;
    }

    public static ModTutorialSteps byName(String name) {
        for (ModTutorialSteps step : ModTutorialSteps.values()) {
            if (!step.name.equals(name)) continue;
            return step;
        }
        return NONE;
    }
}

