/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.util;

import com.craftingdead.core.client.renderer.item.IItemRenderer;
import com.craftingdead.core.client.renderer.item.IRendererProvider;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.Validate;

public class RenderUtil {
    public static final int FULL_LIGHT = 0xF000F0;
    private static final ItemModelGenerator MODEL_GENERATOR = new ItemModelGenerator();
    public static final ResourceLocation ICONS = new ResourceLocation("craftingdead", "textures/gui/icons.png");
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    public static void updateUniform(String name, float value, ShaderGroup shaderGroup) {
        ShaderGroup sg = RenderUtil.minecraft.field_71460_t.func_147706_e();
        if (sg != null) {
            for (Shader shader : sg.field_148031_d) {
                ShaderDefault variable = shader.func_217624_b().func_216538_b(name);
                if (variable == null) continue;
                variable.func_148090_a(value);
            }
        }
    }

    public static void updateUniform(String name, float[] value, ShaderGroup shaderGroup) {
        ShaderGroup sg = RenderUtil.minecraft.field_71460_t.func_147706_e();
        if (sg != null) {
            for (Shader shader : sg.field_148031_d) {
                ShaderDefault variable = shader.func_217624_b().func_216538_b(name);
                if (variable == null) continue;
                variable.func_148097_a(value);
            }
        }
    }

    public static Optional<Vector2f> projectToPlayerView(double x, double y, double z, float partialTicks) {
        Entity renderViewEntity;
        ActiveRenderInfo activeRenderInfo = RenderUtil.minecraft.field_71460_t.func_215316_n();
        Vector3d cameraPos = activeRenderInfo.func_216785_c();
        Quaternion cameraRotation = activeRenderInfo.func_227995_f_().func_227068_g_();
        cameraRotation.func_195892_e();
        Vector3f result = new Vector3f((float)(cameraPos.field_72450_a - x), (float)(cameraPos.field_72448_b - y), (float)(cameraPos.field_72449_c - z));
        result.func_214905_a(cameraRotation);
        if (RenderUtil.minecraft.field_71474_y.field_74336_f && (renderViewEntity = minecraft.func_175606_aa()) instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)renderViewEntity;
            float distanceWalkedModified = playerentity.field_70140_Q;
            float changeInDistance = distanceWalkedModified - playerentity.field_70141_P;
            float lerpDistance = -(distanceWalkedModified + changeInDistance * partialTicks);
            float lerpYaw = MathHelper.func_219799_g((float)partialTicks, (float)playerentity.field_71107_bF, (float)playerentity.field_71109_bG);
            Quaternion q2 = new Quaternion(Vector3f.field_229179_b_, Math.abs(MathHelper.func_76134_b((float)(lerpDistance * (float)Math.PI - 0.2f)) * lerpYaw) * 5.0f, true);
            q2.func_195892_e();
            result.func_214905_a(q2);
            Quaternion q1 = new Quaternion(Vector3f.field_229183_f_, MathHelper.func_76126_a((float)(lerpDistance * (float)Math.PI)) * lerpYaw * 3.0f, true);
            q1.func_195892_e();
            result.func_214905_a(q1);
            Vector3f bobTranslation = new Vector3f(MathHelper.func_76126_a((float)(lerpDistance * (float)Math.PI)) * lerpYaw * 0.5f, -Math.abs(MathHelper.func_76134_b((float)(lerpDistance * (float)Math.PI)) * lerpYaw), 0.0f);
            bobTranslation.setY(-bobTranslation.func_195900_b());
            result.func_229189_a_(bobTranslation);
        }
        double fov = RenderUtil.minecraft.field_71460_t.func_215311_a(activeRenderInfo, partialTicks, true);
        float halfHeight = (float)minecraft.func_228018_at_().func_198087_p() / 2.0f;
        float scale = halfHeight / (result.func_195902_c() * (float)Math.tan(Math.toRadians(fov / 2.0)));
        return (double)result.func_195902_c() > 0.0 ? Optional.empty() : Optional.of(new Vector2f(-result.func_195899_a() * scale, result.func_195900_b() * scale));
    }

    public static boolean isInsideGameFOV(Entity target, boolean firstPerson) {
        double viewerZ;
        double viewerY;
        ActiveRenderInfo activerenderinfo = RenderUtil.minecraft.field_71460_t.func_215316_n();
        Vector3d projectedViewVec3d = firstPerson ? target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0) : activerenderinfo.func_216785_c();
        double viewerX = projectedViewVec3d.func_82615_a();
        if (!target.func_145770_h(viewerX, viewerY = projectedViewVec3d.func_82617_b(), viewerZ = projectedViewVec3d.func_82616_c())) {
            return false;
        }
        AxisAlignedBB renderBoundingBox = target.func_184177_bl();
        if (renderBoundingBox.func_181656_b() || renderBoundingBox.func_72320_b() == 0.0) {
            renderBoundingBox = new AxisAlignedBB(target.func_226277_ct_() - 2.0, target.func_226278_cu_() - 2.0, target.func_226281_cx_() - 2.0, target.func_226277_ct_() + 2.0, target.func_226278_cu_() + 2.0, target.func_226281_cx_() + 2.0);
        }
        return RenderUtil.createClippingHelper(1.0f, firstPerson).func_228957_a_(renderBoundingBox);
    }

    public static ClippingHelper createClippingHelper(float partialTicks, boolean firstPerson) {
        GameRenderer gameRenderer = RenderUtil.minecraft.field_71460_t;
        ActiveRenderInfo activerenderinfo = RenderUtil.minecraft.field_71460_t.func_215316_n();
        Vector3d projectedViewVec3d = firstPerson ? RenderUtil.minecraft.field_71439_g.func_213303_ch().func_72441_c(0.0, (double)RenderUtil.minecraft.field_71439_g.func_70047_e(), 0.0) : activerenderinfo.func_216785_c();
        double viewerX = projectedViewVec3d.func_82615_a();
        double viewerY = projectedViewVec3d.func_82617_b();
        double viewerZ = projectedViewVec3d.func_82616_c();
        float pitch = firstPerson ? RenderUtil.minecraft.field_71439_g.field_70125_A : activerenderinfo.func_216777_e();
        float yaw = firstPerson ? RenderUtil.minecraft.field_71439_g.field_70177_z : activerenderinfo.func_216778_f();
        MatrixStack cameraRotationStack = new MatrixStack();
        cameraRotationStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        cameraRotationStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw + 180.0f));
        Matrix4f fovAndWindowMatrix = new MatrixStack().func_227866_c_().func_227870_a_();
        fovAndWindowMatrix.func_226595_a_(gameRenderer.func_228382_a_(activerenderinfo, partialTicks, true));
        ClippingHelper clippingHelper = new ClippingHelper(cameraRotationStack.func_227866_c_().func_227870_a_(), fovAndWindowMatrix);
        clippingHelper.func_228952_a_(viewerX, viewerY, viewerZ);
        return clippingHelper;
    }

    public static void fill(MatrixStack matrixStack, int x, int y, int width, int height, int colour) {
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)colour);
    }

    public static void drawGradientRectangle(double x, double y, double x2, double y2, int startColor, int endColor) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        buffer.func_225582_a_(x, y2, 0.0).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_225582_a_(x2, y2, 0.0).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_225582_a_(x2, y, 0.0).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_225582_a_(x, y, 0.0).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    public static void applyPlayerCrouchRotation(MatrixStack matrix) {
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(0.5f));
        matrix.func_227861_a_(0.0, (double)0.2f, (double)-0.1f);
    }

    public static boolean hasGenerationMarker(BlockModel blockModel) {
        return blockModel.func_178310_f().field_178317_b.equals("generation marker");
    }

    public static IBakedModel generateSpriteModel(BlockModel blockModel, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) throws IllegalArgumentException {
        Validate.isTrue((boolean)RenderUtil.hasGenerationMarker(blockModel), (String)"The model does not have a generation marker", (Object[])new Object[0]);
        return MODEL_GENERATOR.func_209579_a(spriteGetter, blockModel).func_228813_a_(bakery, blockModel, spriteGetter, modelTransform, modelLocation, false);
    }

    public static void drawTexturedRectangle(double x, double y, float width, float height, float textureX, float textureY) {
        RenderUtil.drawTexturedRectangle(x, y, x + (double)width, y + (double)height, textureX, textureY, textureX + width, textureY + height, 256.0f, 256.0f);
    }

    public static void drawTexturedRectangle(double x, double y, double x2, double y2, float textureX, float textureY, float textureX2, float textureY2, float width, float height) {
        float u = textureX / width;
        float u2 = textureX2 / width;
        float v = textureY / height;
        float v2 = textureY2 / height;
        RenderUtil.drawTexturedRectangle(x, y, x2, y2, u, v, u2, v2);
    }

    public static void drawTexturedRectangle(double x, double y, double width, double height) {
        RenderUtil.drawTexturedRectangle(x, y, x + width, y + height, 0.0f, 1.0f, 1.0f, 0.0f);
    }

    public static void drawTexturedRectangle(double x, double y, double x2, double y2, float u, float v, float u2, float v2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(x, y2, 0.0).func_225583_a_(u, v).func_181675_d();
        bufferbuilder.func_225582_a_(x2, y2, 0.0).func_225583_a_(u2, v).func_181675_d();
        bufferbuilder.func_225582_a_(x2, y, 0.0).func_225583_a_(u2, v2).func_181675_d();
        bufferbuilder.func_225582_a_(x, y, 0.0).func_225583_a_(u, v2).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void bind(ResourceLocation resourceLocation) {
        minecraft.func_110434_K().func_110577_a(resourceLocation);
    }

    public static double getFitScale(double imageWidth, double imageHeight) {
        double widthScale = (double)minecraft.func_228018_at_().func_198105_m() / imageWidth;
        double heightScale = (double)minecraft.func_228018_at_().func_198083_n() / imageHeight;
        double scale = imageHeight * widthScale < (double)minecraft.func_228018_at_().func_198083_n() ? heightScale : widthScale;
        return scale / minecraft.func_228018_at_().func_198100_s();
    }

    public static void renderItemIntoGUI(ItemStack itemStack, int x, int y, int colour) {
        RenderUtil.renderItemModelIntoGUI(itemStack, x, y, colour, minecraft.func_175599_af().func_184393_a(itemStack, null, null), false);
    }

    public static void renderItemIntoGUI(ItemStack itemStack, int x, int y, int colour, boolean useCustomRenderer) {
        RenderUtil.renderItemModelIntoGUI(itemStack, x, y, colour, minecraft.func_175599_af().func_184393_a(itemStack, null, null), useCustomRenderer);
    }

    public static void renderItemModelIntoGUI(ItemStack itemStack, int x, int y, int colour, IBakedModel bakedmodel, boolean useCustomRenderer) {
        boolean enable3dLight;
        RenderSystem.pushMatrix();
        RenderUtil.minecraft.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        RenderUtil.minecraft.field_71446_o.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + RenderUtil.minecraft.func_175599_af().field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = enable3dLight = !bakedmodel.func_230044_c_();
        if (enable3dLight) {
            RenderHelper.func_227783_c_();
        }
        if (useCustomRenderer && itemStack.func_77973_b() instanceof IRendererProvider) {
            IItemRenderer itemRenderer = ((IRendererProvider)itemStack.func_77973_b()).getRenderer();
            itemRenderer.renderGeneric(itemStack, new MatrixStack(), (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0, OverlayTexture.field_229196_a_);
        } else {
            RenderUtil.renderItemColour(itemStack, ItemCameraTransforms.TransformType.GUI, false, new MatrixStack(), (IRenderTypeBuffer)renderTypeBuffer, colour, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        }
        renderTypeBuffer.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (enable3dLight) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public static void renderItemColour(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int colour, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn) {
        if (!itemStackIn.func_190926_b()) {
            boolean flag;
            matrixStackIn.func_227860_a_();
            boolean bl = flag = transformTypeIn == ItemCameraTransforms.TransformType.GUI || transformTypeIn == ItemCameraTransforms.TransformType.GROUND || transformTypeIn == ItemCameraTransforms.TransformType.FIXED;
            if (itemStackIn.func_77973_b() == Items.field_203184_eO && flag) {
                modelIn = minecraft.func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            modelIn = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStackIn, (IBakedModel)modelIn, (ItemCameraTransforms.TransformType)transformTypeIn, (boolean)leftHand);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (!modelIn.func_188618_c() && (itemStackIn.func_77973_b() != Items.field_203184_eO || flag)) {
                Block block;
                boolean flag1 = transformTypeIn != ItemCameraTransforms.TransformType.GUI && !transformTypeIn.func_241716_a_() && itemStackIn.func_77973_b() instanceof BlockItem ? !((block = ((BlockItem)itemStackIn.func_77973_b()).func_179223_d()) instanceof BreakableBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                if (modelIn.isLayered()) {
                    ForgeHooksClient.drawItemLayered((ItemRenderer)minecraft.func_175599_af(), (IBakedModel)modelIn, (ItemStack)itemStackIn, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn, (boolean)flag1);
                } else {
                    IVertexBuilder ivertexbuilder;
                    RenderType rendertype = RenderTypeLookup.func_239219_a_((ItemStack)itemStackIn, (boolean)flag1);
                    if (itemStackIn.func_77973_b() == Items.field_151111_aL && itemStackIn.func_77962_s()) {
                        matrixStackIn.func_227860_a_();
                        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
                        if (transformTypeIn == ItemCameraTransforms.TransformType.GUI) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.5f);
                        } else if (transformTypeIn.func_241716_a_()) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.75f);
                        }
                        ivertexbuilder = flag1 ? ItemRenderer.func_241732_b_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (MatrixStack.Entry)matrixstack$entry) : ItemRenderer.func_241731_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (MatrixStack.Entry)matrixstack$entry);
                        matrixStackIn.func_227865_b_();
                    } else {
                        ivertexbuilder = flag1 ? ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s()) : ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s());
                    }
                    RenderUtil.renderModelColour(modelIn, colour, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
                }
            } else {
                itemStackIn.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    public static void renderModelColour(IBakedModel bakedModel, int colour, int packedLight, int packedOverlay, MatrixStack matrixStack, IVertexBuilder vertexBuilder) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            RenderUtil.renderQuadsColour(matrixStack, vertexBuilder, bakedModel.getQuads(null, direction, random, (IModelData)EmptyModelData.INSTANCE), colour, packedLight, packedOverlay);
        }
        random.setSeed(42L);
        RenderUtil.renderQuadsColour(matrixStack, vertexBuilder, bakedModel.getQuads(null, null, random, (IModelData)EmptyModelData.INSTANCE), colour, packedLight, packedOverlay);
    }

    private static void renderQuadsColour(MatrixStack matrixStack, IVertexBuilder vertexBuilder, List<BakedQuad> quads, int colour, int packedLight, int packedOverlay) {
        MatrixStack.Entry matrixStackEntry = matrixStack.func_227866_c_();
        for (BakedQuad bakedQuad : quads) {
            float r = (float)(colour >> 16 & 0xFF) / 255.0f;
            float g = (float)(colour >> 8 & 0xFF) / 255.0f;
            float b = (float)(colour & 0xFF) / 255.0f;
            float a = (float)(colour >> 24 & 0xFF) / 255.0f;
            vertexBuilder.addVertexData(matrixStackEntry, bakedQuad, r, g, b, a, packedLight, packedOverlay);
        }
    }

    public static float easeInOutSine(float value) {
        return -(MathHelper.func_76134_b((float)((float)Math.PI * value)) - 1.0f) / 2.0f;
    }
}

