/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.data;

import com.craftingdead.core.data.ModChestLootTables;
import com.craftingdead.core.world.storage.loot.ModLootTables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;

public class ModLootTableProvider
extends LootTableProvider {
    public ModLootTableProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Pair.of(ModChestLootTables::new, (Object)LootParameterSets.field_216261_b));
        return builder.build();
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationTracker) {
        for (ResourceLocation location2 : Sets.difference(ModLootTables.getLootTables(), map.keySet())) {
            validationTracker.func_227530_a_("Missing built-in table: " + location2);
        }
        map.forEach((location, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationTracker, (ResourceLocation)location, (LootTable)lootTable));
    }

    public String func_200397_b() {
        return "Crafting Dead Loot Tables";
    }
}

