/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class BounceableProjectileEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private UUID ownerId;
    private BlockState blockStanding;
    private boolean stoppedInGround;
    private int totalTicksInAir;
    private int motionStopCount;

    public BounceableProjectileEntity(EntityType<? extends BounceableProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    public BounceableProjectileEntity(EntityType<? extends BounceableProjectileEntity> entityType, double x, double y, double z, World world) {
        this(entityType, world);
        this.func_70107_b(x, y, z);
    }

    public BounceableProjectileEntity(EntityType<? extends BounceableProjectileEntity> entityType, LivingEntity throwerEntity, World world) {
        this(entityType, throwerEntity.func_226277_ct_(), throwerEntity.func_226280_cw_(), throwerEntity.func_226281_cx_(), world);
        this.ownerId = throwerEntity.func_110124_au();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos currentBlockPos = this.func_233580_cy_();
        BlockState currentBlockState = this.field_70170_p.func_180495_p(currentBlockPos);
        if (this.stoppedInGround) {
            boolean shouldMove;
            if (this.blockStanding == null) {
                this.blockStanding = currentBlockState;
            }
            boolean notCollided = this.blockStanding != currentBlockState && this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_186662_g(0.0625));
            boolean bl = shouldMove = !this.func_213322_ci().equals((Object)Vector3d.field_186680_a) || notCollided;
            if (shouldMove) {
                this.stoppedInGround = false;
                this.blockStanding = null;
            }
        }
        if (!this.stoppedInGround) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, 0.04, 0.0));
            }
            ++this.totalTicksInAir;
            Vector3d position = this.func_213303_ch();
            Vector3d motionBeforeHit = this.func_213322_ci();
            BlockRayTraceResult blockRayTraceResult = this.field_70170_p.func_217299_a(new RayTraceContext(position, position.func_178787_e(motionBeforeHit), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            Vector3d nextBounceMotion = null;
            if (blockRayTraceResult.func_216346_c() != RayTraceResult.Type.MISS) {
                BlockState blockHitState = this.field_70170_p.func_180495_p(blockRayTraceResult.func_216350_a());
                Vector3d difference = blockRayTraceResult.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.func_213317_d(difference);
                Vector3d vec = difference.func_72432_b().func_186678_a(0.05);
                this.func_70107_b(this.func_226277_ct_() - vec.field_72450_a, this.func_226278_cu_() - vec.field_72448_b, this.func_226281_cx_() - vec.field_72449_c);
                Float bounceFactor = this.getBounceFactor(blockRayTraceResult);
                if (bounceFactor != null) {
                    switch (blockRayTraceResult.func_216354_b()) {
                        case UP: {
                            nextBounceMotion = Math.abs(motionBeforeHit.field_72448_b) > 0.1 ? motionBeforeHit.func_216372_d(0.63, (double)(-bounceFactor.floatValue()), 0.63) : Vector3d.field_186680_a;
                            break;
                        }
                        case DOWN: {
                            nextBounceMotion = motionBeforeHit.func_216372_d(0.9, (double)(-bounceFactor.floatValue()), 0.9);
                            break;
                        }
                        case WEST: 
                        case EAST: {
                            nextBounceMotion = motionBeforeHit.func_216372_d((double)(-bounceFactor.floatValue()), 0.9, 0.9);
                            break;
                        }
                        case SOUTH: 
                        case NORTH: {
                            nextBounceMotion = motionBeforeHit.func_216372_d(0.9, 0.9, (double)(-bounceFactor.floatValue()));
                            break;
                        }
                    }
                } else {
                    nextBounceMotion = Vector3d.field_186680_a;
                }
                this.onSurfaceHit(blockRayTraceResult);
                if (this.func_70089_S() && nextBounceMotion != null && blockRayTraceResult.func_216354_b() == Direction.UP && nextBounceMotion.func_72433_c() < 0.1) {
                    nextBounceMotion = Vector3d.field_186680_a;
                    this.stoppedInGround = true;
                    this.blockStanding = blockHitState;
                    this.onMotionStop(++this.motionStopCount);
                }
            }
            Vector3d currentMotion = this.func_213322_ci();
            double nextX = this.func_226277_ct_() + currentMotion.field_72450_a;
            double nextY = this.func_226278_cu_() + currentMotion.field_72448_b;
            double nextZ = this.func_226281_cx_() + currentMotion.field_72449_c;
            this.func_70107_b(nextX, nextY, nextZ);
            this.func_145775_I();
            if (nextBounceMotion != null) {
                this.func_213317_d(nextBounceMotion);
            }
        }
    }

    public abstract void onSurfaceHit(BlockRayTraceResult var1);

    public abstract void onMotionStop(int var1);

    public void shootFromEntity(Entity entity, float x, float y, float z, float force, float p_184538_6_) {
        float f = -MathHelper.func_76126_a((float)(y * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(x * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(y * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(x * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, force, p_184538_6_);
        Vector3d vec3d = entity.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d.field_72450_a, entity.func_233570_aj_() ? 0.0 : vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public void shoot(double x, double y, double z, float force, float p_70186_8_) {
        Vector3d vec = new Vector3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_).func_186678_a((double)force);
        this.func_213317_d(vec);
        float f = MathHelper.func_76133_a((double)BounceableProjectileEntity.func_213296_b((Vector3d)vec));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec.field_72450_a, (double)vec.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public int getTotalTicksInAir() {
        return this.totalTicksInAir;
    }

    public BlockState getBlockStanding() {
        return this.blockStanding;
    }

    public boolean isStoppedInGround() {
        return this.stoppedInGround;
    }

    public int getMotionStopCount() {
        return this.motionStopCount;
    }

    protected float getGravityVelocity() {
        return 1.04f;
    }

    public Float getBounceFactor(BlockRayTraceResult blockRayTraceResult) {
        return Float.valueOf(0.375f);
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.ownerId != null) {
            compound.func_218657_a("owner", (INBT)NBTUtil.func_240626_a_((UUID)this.ownerId));
        }
        compound.func_74757_a("inGround", this.stoppedInGround);
        compound.func_74768_a("motionStopCount", this.motionStopCount);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("owner", 10)) {
            this.ownerId = NBTUtil.func_186860_b((INBT)compound.func_74775_l("owner"));
        }
        this.stoppedInGround = compound.func_74767_n("inGround");
        this.motionStopCount = compound.func_74762_e("motionStopCount");
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeBoolean(this.stoppedInGround);
        buffer.writeInt(this.totalTicksInAir);
        buffer.writeInt(this.motionStopCount);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.stoppedInGround = buffer.readBoolean();
        this.totalTicksInAir = buffer.readInt();
        this.motionStopCount = buffer.readInt();
    }

    @Nullable
    public Optional<Entity> getThrower() {
        if (this.field_70170_p instanceof ServerWorld) {
            return Optional.ofNullable(((ServerWorld)this.field_70170_p).func_217461_a(this.ownerId));
        }
        return Optional.empty();
    }
}

