/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.entity.grenade;

import com.craftingdead.core.entity.ModEntityTypes;
import com.craftingdead.core.entity.grenade.GrenadeEntity;
import com.craftingdead.core.item.GrenadeItem;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.util.ModDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Triple;

public class C4ExplosiveEntity
extends GrenadeEntity {
    private static final Triple<SoundEvent, Float, Float> C4_BOUNCE_SOUND = Triple.of((Object)SoundEvents.field_187804_ed, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.5f));

    public C4ExplosiveEntity(EntityType<? extends GrenadeEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    public C4ExplosiveEntity(LivingEntity thrower, World worldIn) {
        super((EntityType<? extends GrenadeEntity>)((EntityType)ModEntityTypes.C4_EXPLOSIVE.get()), thrower, worldIn);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (ModDamageSource.isGunDamage(source) || source.func_94541_c() || source.func_76347_k()) {
            this.setActivated(true);
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void onGrenadeTick() {
    }

    @Override
    public void onActivationStateChange(boolean activated) {
        if (activated && !this.field_70170_p.func_201670_d()) {
            this.func_70106_y();
            this.field_70170_p.func_230546_a_((Entity)this, this.createDamageSource(), null, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_(), 4.0f, false, Explosion.Mode.NONE);
        }
    }

    @Override
    public boolean canBePickedUp(PlayerEntity playerFrom) {
        return this.isStoppedInGround();
    }

    @Override
    public Float getBounceFactor(BlockRayTraceResult blockRayTraceResult) {
        return blockRayTraceResult.func_216354_b() == Direction.UP ? null : super.getBounceFactor(blockRayTraceResult);
    }

    @Override
    public boolean canBeRemotelyActivated() {
        return true;
    }

    @Override
    public Triple<SoundEvent, Float, Float> getBounceSound(BlockRayTraceResult blockRayTraceResult) {
        return C4_BOUNCE_SOUND;
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)ModItems.C4.get();
    }

    @Override
    public void onMotionStop(int stopsCount) {
    }
}

