/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.entity.grenade;

import com.craftingdead.core.entity.ModEntityTypes;
import com.craftingdead.core.entity.grenade.GrenadeEntity;
import com.craftingdead.core.item.GrenadeItem;
import com.craftingdead.core.item.GunItem;
import com.craftingdead.core.item.ModItems;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Util;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class DecoyGrenadeEntity
extends GrenadeEntity {
    private long lastShotMs;
    private final GunItem gunItem;

    public DecoyGrenadeEntity(EntityType<? extends GrenadeEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.gunItem = DecoyGrenadeEntity.getRandomGun(this.field_70146_Z);
    }

    public DecoyGrenadeEntity(LivingEntity thrower, World worldIn) {
        super((EntityType<? extends GrenadeEntity>)((EntityType)ModEntityTypes.DECOY_GRENADE.get()), thrower, worldIn);
        this.gunItem = DecoyGrenadeEntity.getRandomGun(this.field_70146_Z);
    }

    @Override
    public void onMotionStop(int stopsCount) {
        if (stopsCount == 1) {
            this.setActivated(true);
        }
    }

    @Override
    public void onActivationStateChange(boolean activated) {
        if (!activated) {
            if (!this.field_70170_p.func_201670_d()) {
                this.func_70106_y();
                this.field_70170_p.func_230546_a_((Entity)this, this.createDamageSource(), null, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_(), 1.3f, false, Explosion.Mode.NONE);
            }
        } else {
            this.playFakeShoot();
        }
    }

    @Override
    public Integer getMinimumTicksUntilAutoDeactivation() {
        return 400;
    }

    @Override
    public void onGrenadeTick() {
        if (!this.isActivated()) {
            return;
        }
        if (!this.field_70170_p.func_201670_d()) {
            if (this.field_70146_Z.nextInt(20) == 0 && this.canShoot()) {
                this.playFakeShoot();
            }
        } else {
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197601_L, true, this.func_226277_ct_(), this.func_226278_cu_() + 0.4, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean canShoot() {
        long fireDelayMs = this.gunItem.getGunType().getFireDelayMs();
        return Util.func_211177_b() - this.lastShotMs >= fireDelayMs;
    }

    public void playFakeShoot() {
        this.func_184185_a(this.gunItem.getGunType().getShootSound().get(), 1.5f, 1.0f);
        this.lastShotMs = Util.func_211177_b();
    }

    @Override
    public boolean isAttracting() {
        return this.isActivated();
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)ModItems.DECOY_GRENADE.get();
    }

    private static GunItem getRandomGun(Random random) {
        List possibleGuns = ModItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(item -> item instanceof GunItem).map(item -> (GunItem)item).collect(Collectors.toList());
        return (GunItem)possibleGuns.get(random.nextInt(possibleGuns.size()));
    }
}

