/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.entity.grenade;

import com.craftingdead.core.entity.ModEntityTypes;
import com.craftingdead.core.entity.grenade.GrenadeEntity;
import com.craftingdead.core.item.GrenadeItem;
import com.craftingdead.core.item.ModItems;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Triple;

public class FireGrenadeEntity
extends GrenadeEntity {
    private static final double FIRE_RADIUS = 2.0;
    private static final Triple<SoundEvent, Float, Float> FIRE_GRENADE_BOUNCE_SOUND = Triple.of((Object)SoundEvents.field_187561_bM, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.9f));

    public FireGrenadeEntity(EntityType<? extends GrenadeEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    public FireGrenadeEntity(LivingEntity thrower, World worldIn) {
        super((EntityType<? extends GrenadeEntity>)((EntityType)ModEntityTypes.FIRE_GRENADE.get()), thrower, worldIn);
    }

    @Override
    public void onSurfaceHit(BlockRayTraceResult blockRayTraceResult) {
        super.onSurfaceHit(blockRayTraceResult);
        if (blockRayTraceResult.func_216354_b() == Direction.UP) {
            this.setActivated(true);
        }
    }

    @Override
    public void onActivationStateChange(boolean activated) {
        if (activated && !this.field_70170_p.func_201670_d()) {
            this.func_70106_y();
            this.field_70170_p.func_230546_a_((Entity)this, this.createDamageSource(), null, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_(), 2.0f, true, Explosion.Mode.NONE);
            BlockPos.func_218281_b((BlockPos)this.func_233580_cy_().func_177963_a(-2.0, 0.0, -2.0), (BlockPos)this.func_233580_cy_().func_177963_a(2.0, 0.0, 2.0)).forEach(blockPos -> {
                if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() == Blocks.field_150350_a && Math.random() <= 0.8) {
                    this.field_70170_p.func_175656_a(blockPos, Blocks.field_150480_ab.func_176223_P());
                }
            });
        }
    }

    @Override
    public void onGrenadeTick() {
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)ModItems.FIRE_GRENADE.get();
    }

    @Override
    public Triple<SoundEvent, Float, Float> getBounceSound(BlockRayTraceResult blockRayTraceResult) {
        return blockRayTraceResult.func_216354_b() == Direction.UP ? FIRE_GRENADE_BOUNCE_SOUND : super.getBounceSound(blockRayTraceResult);
    }

    @Override
    public void onMotionStop(int stopsCount) {
    }
}

