/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.entity.grenade;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.entity.ModEntityTypes;
import com.craftingdead.core.entity.grenade.GrenadeEntity;
import com.craftingdead.core.hat.IHat;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.item.GrenadeItem;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.particle.RGBFlashParticleData;
import com.craftingdead.core.potion.ModEffects;
import com.craftingdead.core.util.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FlashGrenadeEntity
extends GrenadeEntity {
    public static final double FLASH_MAX_RANGE = 50.0;
    public static final int EFFECT_MAX_DURATION = 110;

    public FlashGrenadeEntity(EntityType<? extends GrenadeEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    public FlashGrenadeEntity(LivingEntity thrower, World worldIn) {
        super((EntityType<? extends GrenadeEntity>)((EntityType)ModEntityTypes.FLASH_GRENADE.get()), thrower, worldIn);
    }

    @Override
    public void onActivationStateChange(boolean activated) {
        if (activated) {
            this.flash();
        } else if (!this.field_70170_p.func_201670_d()) {
            this.func_70106_y();
        }
    }

    @Override
    public Integer getMinimumTicksUntilAutoActivation() {
        return 30;
    }

    @Override
    public Integer getMinimumTicksUntilAutoDeactivation() {
        return 5;
    }

    @Override
    public void onGrenadeTick() {
    }

    @Override
    public void onMotionStop(int stopsCount) {
    }

    private void flash() {
        if (this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_195594_a((IParticleData)new RGBFlashParticleData(1.0f, 1.0f, 1.0f, 2.0f), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            CraftingDead.getInstance().getClientDist().checkApplyFlashEffects(this);
        } else {
            this.func_184185_a(SoundEvents.field_187539_bB, 3.0f, 1.2f);
            this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(50.0), entity -> entity instanceof LivingEntity && !(entity instanceof PlayerEntity)).stream().map(entity -> (LivingEntity)entity).forEach(livingEntity -> {
                boolean wasFlashApplied;
                int duration = this.calculateDuration((LivingEntity)livingEntity, EntityUtil.isInsideFOV(livingEntity, this, 90.0f));
                if (duration > 0 && (wasFlashApplied = ModEffects.applyOrOverrideIfLonger(livingEntity, new EffectInstance((Effect)ModEffects.FLASH_BLINDNESS.get(), duration))) && livingEntity instanceof MobEntity) {
                    MobEntity mobEntity = (MobEntity)livingEntity;
                    mobEntity.func_70624_b(null);
                }
            });
        }
    }

    public int calculateDuration(LivingEntity viewerEntity, boolean insideFOV) {
        if (!viewerEntity.func_70685_l((Entity)this)) {
            return 0;
        }
        ItemStack hatItemStack = viewerEntity.getCapability(ModCapabilities.LIVING).map(living -> living.getItemHandler().getStackInSlot(InventorySlotType.HAT.getIndex())).orElse(ItemStack.field_190927_a);
        boolean isImmuneToFlashes = hatItemStack.getCapability(ModCapabilities.HAT).map(IHat::isImmuneToFlashes).orElse(false);
        if (insideFOV && !isImmuneToFlashes) {
            double distanceProportion = MathHelper.func_151237_a((double)((double)this.func_70032_d(viewerEntity.getEntity()) / 50.0), (double)0.0, (double)1.0);
            int calculatedDuration = (int)MathHelper.func_219803_d((double)(1.0 - distanceProportion), (double)0.0, (double)110.0);
            if (!(viewerEntity instanceof PlayerEntity)) {
                calculatedDuration *= 4;
            }
            return calculatedDuration;
        }
        return viewerEntity instanceof PlayerEntity ? 5 : 0;
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)ModItems.FLASH_GRENADE.get();
    }
}

