/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.entity.grenade;

import com.craftingdead.core.entity.BounceableProjectileEntity;
import com.craftingdead.core.item.GrenadeItem;
import com.craftingdead.core.util.ModDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;

public abstract class GrenadeEntity
extends BounceableProjectileEntity {
    private static final Triple<SoundEvent, Float, Float> DEFAULT_BOUNCE_SOUND = Triple.of((Object)SoundEvents.field_219681_jK, (Object)Float.valueOf(0.5f), (Object)Float.valueOf(2.0f));
    private static final DataParameter<Boolean> ACTIVATED = EntityDataManager.func_187226_a(GrenadeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int activatedTicksCount = 0;
    private int deactivatedTicksCount = 0;

    public GrenadeEntity(EntityType<? extends GrenadeEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    public GrenadeEntity(EntityType<? extends GrenadeEntity> entityIn, LivingEntity thrower, World worldIn) {
        super(entityIn, thrower, worldIn);
    }

    public abstract GrenadeItem asItem();

    public abstract void onGrenadeTick();

    public abstract void onActivationStateChange(boolean var1);

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S()) {
            if (this.isActivated()) {
                ++this.activatedTicksCount;
            } else {
                ++this.deactivatedTicksCount;
            }
            this.onGrenadeTick();
        }
        if (this.func_70089_S() && this.getMinimumTicksUntilAutoActivation() != null && !this.isActivated() && this.deactivatedTicksCount >= this.getMinimumTicksUntilAutoActivation()) {
            this.setActivated(true);
        }
        if (this.func_70089_S() && this.getMinimumTicksUntilAutoDeactivation() != null && this.isActivated() && this.activatedTicksCount >= this.getMinimumTicksUntilAutoDeactivation()) {
            this.setActivated(false);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (ModDamageSource.isGunDamage(source)) {
            EntityDamageSource entitySource = (EntityDamageSource)source;
            this.func_213317_d(entitySource.func_76346_g().func_70040_Z().func_186678_a(1.5));
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void onSurfaceHit(BlockRayTraceResult blockRayTraceResult) {
        Triple<SoundEvent, Float, Float> bounceSound = this.getBounceSound(blockRayTraceResult);
        if (this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)bounceSound.getLeft(), SoundCategory.NEUTRAL, ((Float)bounceSound.getMiddle()).floatValue(), ((Float)bounceSound.getRight()).floatValue(), false);
        }
    }

    public final ActionResultType func_184230_a(PlayerEntity playerEntity, Hand hand) {
        boolean canPickup;
        boolean bl = canPickup = !playerEntity.func_226563_dT_() && this.canBePickedUp(playerEntity);
        if (canPickup) {
            this.func_70106_y();
            playerEntity.func_191521_c(new ItemStack((IItemProvider)this.asItem(), 1));
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 1.4f + 2.0f, false);
        }
        return canPickup ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public boolean canBePickedUp(PlayerEntity playerFrom) {
        return false;
    }

    public Triple<SoundEvent, Float, Float> getBounceSound(BlockRayTraceResult blockRayTraceResult) {
        return DEFAULT_BOUNCE_SOUND;
    }

    public boolean canBeRemotelyActivated() {
        return false;
    }

    public boolean isAttracting() {
        return false;
    }

    public void setActivated(boolean activated) {
        boolean previousValue = (Boolean)this.func_184212_Q().func_187225_a(ACTIVATED);
        this.func_184212_Q().func_187227_b(ACTIVATED, (Object)activated);
        if (activated != previousValue) {
            if (!activated) {
                this.deactivatedTicksCount = 0;
            } else {
                this.activatedTicksCount = 0;
            }
            this.onActivationStateChange(activated);
        }
    }

    public Integer getMinimumTicksUntilAutoActivation() {
        return null;
    }

    public Integer getMinimumTicksUntilAutoDeactivation() {
        return null;
    }

    public boolean isActivated() {
        return (Boolean)this.func_184212_Q().func_187225_a(ACTIVATED);
    }

    public int getActivatedTicksCount() {
        return this.activatedTicksCount;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("activated", this.isActivated());
        compound.func_74768_a("activatedTicksCount", this.activatedTicksCount);
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setActivated(compound.func_74767_n("activated"));
        this.activatedTicksCount = compound.func_74762_e("activatedTicksCount");
    }

    @Override
    public void writeSpawnData(PacketBuffer buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.activatedTicksCount);
    }

    @Override
    public void readSpawnData(PacketBuffer buffer) {
        super.readSpawnData(buffer);
        this.activatedTicksCount = buffer.readInt();
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ACTIVATED, (Object)false);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public DamageSource createDamageSource() {
        return ModDamageSource.causeUnscaledExplosionDamage(this.getThrower().filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).orElse(null));
    }
}

