/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.entity.grenade;

import com.craftingdead.core.entity.ModEntityTypes;
import com.craftingdead.core.entity.grenade.GrenadeEntity;
import com.craftingdead.core.item.GrenadeItem;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.particle.GrenadeSmokeParticleData;
import net.minecraft.block.BlockState;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class SmokeGrenadeEntity
extends GrenadeEntity {
    public static final GrenadeSmokeParticleData LARGE_WHITE_SMOKE = new GrenadeSmokeParticleData(1.0f, 1.0f, 1.0f, 10.0f);
    private static final float START_DECREASING_PITCH_AT = 0.65f;
    private static final int FIRE_BLOCK_STATE_FLAGS = 1;

    public SmokeGrenadeEntity(EntityType<? extends GrenadeEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    public SmokeGrenadeEntity(LivingEntity thrower, World worldIn) {
        super((EntityType<? extends GrenadeEntity>)((EntityType)ModEntityTypes.SMOKE_GRENADE.get()), thrower, worldIn);
    }

    @Override
    public Integer getMinimumTicksUntilAutoDeactivation() {
        return 500;
    }

    @Override
    public void onMotionStop(int stopsCount) {
        if (stopsCount == 1) {
            this.setActivated(true);
        }
    }

    @Override
    public void onActivationStateChange(boolean activated) {
        if (!activated && !this.field_70170_p.func_201670_d()) {
            this.func_70106_y();
        }
    }

    @Override
    public void onGrenadeTick() {
        if (!this.isActivated()) {
            return;
        }
        int activatedTicksCount = this.getActivatedTicksCount();
        double radius = MathHelper.func_219803_d((double)(Math.min((double)activatedTicksCount, 30.0) / 30.0), (double)2.0, (double)5.0);
        if (this.field_70170_p.func_201670_d()) {
            if (activatedTicksCount % 10 == 0) {
                int maximumDuration = this.getMinimumTicksUntilAutoDeactivation();
                float progress = Math.max((float)activatedTicksCount - (float)maximumDuration * 0.65f, 0.0f) / ((float)maximumDuration * 0.35000002f);
                float gradualPitch = MathHelper.func_219799_g((float)(1.0f - progress), (float)0.5f, (float)1.7f);
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187646_bt, SoundCategory.HOSTILE, 1.5f, gradualPitch, false);
            }
            if (activatedTicksCount % 5 == 0) {
                double halfSphereVolume = 4.1887902047863905 * Math.pow(radius / 2.0, 3.0);
                int i = 0;
                while ((double)i < halfSphereVolume) {
                    double theta = this.field_70146_Z.nextDouble() * 2.0 * Math.PI;
                    double phi = Math.acos(2.0 * this.field_70146_Z.nextDouble() - 1.0);
                    double extraX = radius * Math.sin(phi) * Math.cos(theta);
                    double extraY = radius * Math.abs(Math.sin(phi) * Math.sin(theta)) * this.field_70146_Z.nextDouble();
                    double extraZ = radius * Math.cos(phi);
                    this.field_70170_p.func_195590_a((IParticleData)LARGE_WHITE_SMOKE, true, this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ, 0.0, 0.0, 0.0);
                    ++i;
                }
            }
        } else if (activatedTicksCount % 10 == 0) {
            double detectionRadius = radius + 1.5;
            BlockPos from = this.func_233580_cy_().func_177963_a(-detectionRadius, 0.0, -detectionRadius);
            BlockPos to = this.func_233580_cy_().func_177963_a(detectionRadius, detectionRadius, detectionRadius);
            BlockPos.func_218281_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> {
                BlockState blockState;
                double zDiff;
                double xDiff = this.func_226277_ct_() - (double)blockPos.func_177958_n();
                double distance2D = MathHelper.func_76133_a((double)(xDiff * xDiff + (zDiff = this.func_226281_cx_() - (double)blockPos.func_177952_p()) * zDiff));
                if (distance2D <= detectionRadius && (blockState = this.field_70170_p.func_180495_p(blockPos)).func_177230_c() instanceof FireBlock) {
                    this.field_70170_p.func_180501_a(blockPos, (BlockState)blockState.func_206870_a((Property)FireBlock.field_176543_a, (Comparable)Integer.valueOf(15)), 1);
                }
            });
        }
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)ModItems.SMOKE_GRENADE.get();
    }
}

