/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.inventory.container;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.inventory.CraftingInventorySlotType;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.inventory.container.GunCraftSlot;
import com.craftingdead.core.inventory.container.ModContainerTypes;
import com.craftingdead.core.inventory.container.PredicateItemHandlerSlot;
import com.craftingdead.core.inventory.container.PredicateSlot;
import com.craftingdead.core.item.AttachmentItem;
import com.craftingdead.core.item.HatItem;
import com.craftingdead.core.item.MeleeWeaponItem;
import com.craftingdead.core.living.ILiving;
import java.util.function.BiPredicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class EquipmentContainer
extends Container {
    private final IItemHandler itemHandler;
    private final CraftResultInventory outputInventory = new CraftResultInventory();
    private final Inventory craftingInventory = new Inventory(4);

    public EquipmentContainer(int windowId, PlayerInventory playerInventory) {
        super((ContainerType)ModContainerTypes.EQUIPMENT.get(), windowId);
        this.itemHandler = ((ILiving)playerInventory.field_70458_d.getCapability(ModCapabilities.LIVING).orElseThrow(() -> new IllegalStateException("No living capability"))).getItemHandler();
        this.craftingInventory.func_110134_a(arg_0 -> ((EquipmentContainer)this).func_75130_a(arg_0));
        int slotSize = 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + (y + 1) * 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 142));
        }
        int equipmentColumnX = 62;
        int equipmentColumnY = 8;
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.itemHandler, InventorySlotType.GUN.getIndex(), equipmentColumnX, equipmentColumnY, (slot, itemStack) -> itemStack.getCapability(ModCapabilities.GUN).isPresent()));
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.itemHandler, InventorySlotType.MELEE.getIndex(), equipmentColumnX, equipmentColumnY += 18, (slot, itemStack) -> itemStack.func_77973_b() instanceof MeleeWeaponItem));
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.itemHandler, InventorySlotType.HAT.getIndex(), equipmentColumnX, equipmentColumnY += 18, (slot, itemStack) -> itemStack.func_77973_b() instanceof HatItem));
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.itemHandler, InventorySlotType.CLOTHING.getIndex(), equipmentColumnX, equipmentColumnY += 18, (slot, itemStack) -> itemStack.getCapability(ModCapabilities.CLOTHING).isPresent()));
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.itemHandler, InventorySlotType.VEST.getIndex(), equipmentColumnX + 18, equipmentColumnY, (slot, itemStack) -> itemStack.getCapability(ModCapabilities.STORAGE).map(storage -> storage.isValidForSlot(InventorySlotType.VEST)).orElse(false)));
        int gunCraftSlotGap = 3;
        int gunCraftY = 8;
        this.func_75146_a(new GunCraftSlot(this.outputInventory, 0, 125, 29, this.craftingInventory));
        BiPredicate<PredicateSlot, ItemStack> attachmentAndPaintPredicate = (slot, itemStack) -> this.getGunStack().getCapability(ModCapabilities.GUN).map(gun -> gun.isAcceptedPaintOrAttachment((ItemStack)itemStack)).orElse(false);
        BiPredicate<PredicateSlot, ItemStack> attachmentPredicate = (slot, itemStack) -> itemStack.func_77973_b() instanceof AttachmentItem && ((AttachmentItem)itemStack.func_77973_b()).getInventorySlot().getIndex() == slot.getSlotIndex();
        this.func_75146_a(new PredicateSlot((IInventory)this.craftingInventory, CraftingInventorySlotType.MUZZLE_ATTACHMENT.getIndex(), 104, 29, attachmentPredicate.and(attachmentAndPaintPredicate)));
        this.func_75146_a(new PredicateSlot((IInventory)this.craftingInventory, CraftingInventorySlotType.UNDERBARREL_ATTACHMENT.getIndex(), 125, 50, attachmentPredicate.and(attachmentAndPaintPredicate)));
        this.func_75146_a(new PredicateSlot((IInventory)this.craftingInventory, CraftingInventorySlotType.OVERBARREL_ATTACHMENT.getIndex(), 125, 8, attachmentPredicate.and(attachmentAndPaintPredicate)));
        BiPredicate<PredicateSlot, ItemStack> paintPredicate = (slot, itemStack) -> itemStack.getCapability(ModCapabilities.PAINT).isPresent();
        this.func_75146_a(new PredicateSlot((IInventory)this.craftingInventory, CraftingInventorySlotType.PAINT.getIndex(), 146, 29, paintPredicate.and(attachmentAndPaintPredicate)));
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerEntity) {
        super.func_75134_a(playerEntity);
        if (!playerEntity.field_70170_p.func_201670_d()) {
            this.func_193327_a(playerEntity, playerEntity.field_70170_p, (IInventory)this.craftingInventory);
            this.func_193327_a(playerEntity, playerEntity.field_70170_p, (IInventory)this.outputInventory);
        }
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public ItemStack getGunStack() {
        return this.outputInventory.func_70301_a(0);
    }

    public boolean isCraftingInventoryEmpty() {
        return this.craftingInventory.func_191420_l();
    }

    public boolean isCraftable() {
        return this.getGunStack().getCapability(ModCapabilities.GUN).map(gunController -> {
            for (int i = 0; i < this.craftingInventory.func_70302_i_(); ++i) {
                ItemStack itemStack = this.craftingInventory.func_70301_a(i);
                if (itemStack.func_190926_b() || gunController.isAcceptedPaintOrAttachment(itemStack)) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int clickedIndex) {
        Slot clickedSlot = (Slot)this.field_75151_b.get(clickedIndex);
        if (clickedSlot != null && clickedSlot.func_75216_d()) {
            if (clickedSlot instanceof GunCraftSlot) {
                return ItemStack.field_190927_a;
            }
            ItemStack clickedStack = clickedSlot.func_75211_c();
            if (clickedIndex < 27 ? !this.func_75135_a(clickedStack, 27, this.field_75151_b.size(), true) : !this.func_75135_a(clickedStack, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (clickedStack.func_190926_b()) {
                clickedSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                clickedSlot.func_75218_e();
            }
        }
        return ItemStack.field_190927_a;
    }
}

