/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item;

import com.craftingdead.core.action.ActionType;
import com.craftingdead.core.action.IAction;
import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.living.ILiving;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ActionItem
extends Item {
    @Nullable
    private final BiFunction<ILiving<?, ?>, BlockPos, IAction> blockActionFactory;
    @Nullable
    private final BiFunction<ILiving<?, ?>, ILiving<?, ?>, IAction> entityActionFactory;

    public ActionItem(Properties properties) {
        super((Item.Properties)properties);
        this.blockActionFactory = properties.blockActionFactory;
        this.entityActionFactory = properties.entityActionFactory;
    }

    public ActionResultType func_111207_a(ItemStack itemStack, PlayerEntity playerEntity, LivingEntity targetEntity, Hand hand) {
        if (!playerEntity.func_130014_f_().func_201670_d()) {
            this.performAction((LivingEntity)playerEntity, targetEntity);
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        if (!playerEntity.func_130014_f_().func_201670_d()) {
            this.performAction((LivingEntity)playerEntity, null);
        }
        return new ActionResult(ActionResultType.PASS, (Object)playerEntity.func_184586_b(hand));
    }

    public void performAction(LivingEntity performerEntity, LivingEntity targetEntity) {
        if (this.entityActionFactory != null) {
            performerEntity.getCapability(ModCapabilities.LIVING).ifPresent(performer -> performer.performAction(this.entityActionFactory.apply((ILiving<?, ?>)performer, targetEntity == null ? null : (ILiving)targetEntity.getCapability(ModCapabilities.LIVING).orElse(null)), false, true));
        }
    }

    public static class Properties
    extends Item.Properties {
        @Nullable
        private BiFunction<ILiving<?, ?>, BlockPos, IAction> blockActionFactory;
        @Nullable
        private BiFunction<ILiving<?, ?>, ILiving<?, ?>, IAction> entityActionFactory;

        public Properties setAction(Supplier<? extends ActionType<?>> actionType) {
            this.entityActionFactory = (performer, target) -> ((ActionType)((Object)((Object)actionType.get()))).createAction((ILiving<?, ?>)performer, (ILiving<?, ?>)target);
            return this;
        }

        public Properties setBlockFactory(BiFunction<ILiving<?, ?>, BlockPos, IAction> blockFactory) {
            this.blockActionFactory = blockFactory;
            return this;
        }

        public Properties setEntityFactory(BiFunction<ILiving<?, ?>, ILiving<?, ?>, IAction> entityFactory) {
            this.entityActionFactory = entityFactory;
            return this;
        }
    }
}

