/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item;

import com.craftingdead.core.inventory.CraftingInventorySlotType;
import com.craftingdead.core.util.Text;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class AttachmentItem
extends Item {
    private final Map<MultiplierType, Float> multipliers;
    private final CraftingInventorySlotType inventorySlot;
    private final boolean soundSuppressor;
    private final boolean scope;

    public AttachmentItem(Properties properties) {
        super((Item.Properties)properties);
        this.multipliers = properties.multipliers;
        this.inventorySlot = properties.inventorySlot;
        this.soundSuppressor = properties.soundSuppressor;
        this.scope = properties.scope;
    }

    public Float getMultiplier(MultiplierType multiplierType) {
        return this.multipliers.getOrDefault((Object)multiplierType, Float.valueOf(1.0f));
    }

    public CraftingInventorySlotType getInventorySlot() {
        return this.inventorySlot;
    }

    public boolean isSoundSuppressor() {
        return this.soundSuppressor;
    }

    public boolean isScope() {
        return this.scope;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, lines, tooltipFlag);
        for (Map.Entry<MultiplierType, Float> entry : this.multipliers.entrySet()) {
            lines.add((ITextComponent)Text.translate(entry.getKey().getTranslationKey(), new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.of(" " + entry.getValue() + "x").func_240699_a_(TextFormatting.RED)));
        }
    }

    public static class Properties
    extends Item.Properties {
        private final Map<MultiplierType, Float> multipliers = new EnumMap<MultiplierType, Float>(MultiplierType.class);
        private CraftingInventorySlotType inventorySlot;
        private boolean soundSuppressor;
        private boolean scope;

        public Properties addMultiplier(MultiplierType modifierType, float multiplier) {
            this.multipliers.put(modifierType, Float.valueOf(multiplier));
            return this;
        }

        public Properties setSoundSuppressor(boolean soundSuppressor) {
            this.soundSuppressor = soundSuppressor;
            return this;
        }

        public Properties setInventorySlot(CraftingInventorySlotType inventorySlot) {
            this.inventorySlot = inventorySlot;
            return this;
        }

        public Properties setScope(boolean scope) {
            this.scope = scope;
            return this;
        }
    }

    public static enum MultiplierType {
        DAMAGE,
        ACCURACY,
        ZOOM;

        private final String translationKey = "attachment_multiplier_type." + this.name().toLowerCase();

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

