/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.capability.SimpleCapabilityProvider;
import com.craftingdead.core.clothing.DefaultClothing;
import com.craftingdead.core.item.ModItems;
import com.craftingdead.core.util.Text;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ClothingItem
extends Item {
    private final boolean enhancedProtection;
    @Nullable
    private final Integer slownessAmplifier;
    private final boolean fireImmunity;

    public ClothingItem(Properties properties) {
        super((Item.Properties)properties);
        this.enhancedProtection = properties.enhancedProtection;
        this.slownessAmplifier = properties.slownessAmplifier;
        this.fireImmunity = properties.fireImmunity;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K) {
            int randomRagAmount = field_77697_d.nextInt(3) + 3;
            for (int i = 0; i < randomRagAmount; ++i) {
                if (field_77697_d.nextBoolean()) {
                    entityLiving.func_199701_a_(new ItemStack(() -> ModItems.CLEAN_RAG.get()));
                    continue;
                }
                entityLiving.func_199701_a_(new ItemStack(() -> ModItems.DIRTY_RAG.get()));
            }
        }
        if (entityLiving instanceof PlayerEntity && this.hasContainerItem(stack)) {
            ((PlayerEntity)entityLiving).func_191521_c(this.getContainerItem(stack));
        }
        stack.func_190918_g(1);
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundNBT nbt) {
        return new SimpleCapabilityProvider(LazyOptional.of(() -> new DefaultClothing(this.enhancedProtection, this.slownessAmplifier, this.fireImmunity, new ResourceLocation(this.getRegistryName().func_110624_b(), "textures/clothing/" + this.getRegistryName().func_110623_a() + "_default.png"))), () -> ModCapabilities.CLOTHING);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, lines, tooltipFlag);
        IFormattableTextComponent armorLevelText = Text.of(this.enhancedProtection).func_240699_a_(TextFormatting.RED);
        lines.add((ITextComponent)Text.translate("item_lore.clothing.enhanced_protection", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)armorLevelText));
        if (this.slownessAmplifier != null) {
            String potionNameAndLevel = I18n.func_135052_a((String)Effects.field_76421_d.func_76393_a(), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("enchantment.level." + (this.slownessAmplifier + 1)), (Object[])new Object[0]);
            lines.add((ITextComponent)Text.of(potionNameAndLevel).func_240699_a_(TextFormatting.GRAY));
        }
        if (this.fireImmunity) {
            lines.add((ITextComponent)Text.translate("item_lore.clothing.immune_to_fire", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public static class Properties
    extends Item.Properties {
        private boolean enhancedProtection;
        private Integer slownessAmplifier;
        private boolean fireImmunity;

        public Properties setEnhancedProtection(boolean enhancedProtection) {
            this.enhancedProtection = enhancedProtection;
            return this;
        }

        public Properties setSlownessAmplifier(int slownessAmplifier) {
            this.slownessAmplifier = slownessAmplifier;
            return this;
        }

        public Properties setFireImmunity(boolean fireImmunity) {
            this.fireImmunity = fireImmunity;
            return this;
        }
    }
}

