/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.capability.SimpleCapabilityProvider;
import com.craftingdead.core.entity.grenade.GrenadeEntity;
import com.craftingdead.core.item.combatslot.CombatSlotType;
import com.craftingdead.core.util.Text;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class GrenadeItem
extends Item {
    private final BiFunction<LivingEntity, World, GrenadeEntity> grenadeEntitySupplier;
    private final float throwSpeed;

    public GrenadeItem(Properties properties) {
        super((Item.Properties)properties);
        this.grenadeEntitySupplier = properties.grenadeEntitySupplier;
        this.throwSpeed = properties.throwSpeed;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> texts, ITooltipFlag tooltipFlag) {
        texts.add((ITextComponent)Text.translate("item_lore.grenade", new Object[0]).func_240699_a_(TextFormatting.GRAY));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            GrenadeEntity grenadeEntity = this.grenadeEntitySupplier.apply((LivingEntity)playerIn, worldIn);
            float force = playerIn.func_225608_bj_() ? 0.4f : this.throwSpeed;
            grenadeEntity.func_70634_a(playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + (double)playerIn.func_70047_e(), playerIn.func_226281_cx_());
            grenadeEntity.shootFromEntity((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, force, 1.0f);
            worldIn.func_217376_c((Entity)grenadeEntity);
        }
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        return ActionResult.func_226248_a_((Object)itemStack);
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundNBT nbt) {
        return new SimpleCapabilityProvider(LazyOptional.of(() -> () -> CombatSlotType.GRENADE), () -> ModCapabilities.COMBAT_SLOT_PROVIDER);
    }

    public static class Properties
    extends Item.Properties {
        private BiFunction<LivingEntity, World, GrenadeEntity> grenadeEntitySupplier;
        private float throwSpeed = 1.45f;

        public Properties setGrenadeEntitySupplier(BiFunction<LivingEntity, World, GrenadeEntity> grenadeEntitySupplier) {
            this.grenadeEntitySupplier = grenadeEntitySupplier;
            return this;
        }

        public Properties setThrowSpeed(float throwSpeed) {
            this.throwSpeed = throwSpeed;
            return this;
        }
    }
}

