/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.client.renderer.item.GunRenderer;
import com.craftingdead.core.client.renderer.item.IRendererProvider;
import com.craftingdead.core.item.AttachmentItem;
import com.craftingdead.core.item.gun.AbstractGunType;
import com.craftingdead.core.item.gun.magazine.IMagazine;
import com.craftingdead.core.util.Text;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;

public class GunItem
extends ShootableItem
implements IRendererProvider {
    private final AbstractGunType<?> gunType;
    private final Supplier<DistExecutor.SafeCallable<GunRenderer>> rendererFactory;

    public GunItem(Properties properties) {
        super((Item.Properties)properties);
        this.gunType = properties.gunType;
        this.rendererFactory = properties.rendererFactory;
    }

    public AbstractGunType<?> getGunType() {
        return this.gunType;
    }

    @Override
    public GunRenderer getRenderer() {
        return (GunRenderer)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, this.rendererFactory);
    }

    public Predicate<ItemStack> func_220004_b() {
        return itemStack -> this.gunType.getAcceptedMagazines().stream().anyMatch(itemStack.func_77973_b()::equals);
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundNBT nbt) {
        return this.gunType.createCapabilityProvider(itemStack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> lines, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, lines, tooltipFlag);
        itemStack.getCapability(ModCapabilities.GUN).ifPresent(gun -> {
            IFormattableTextComponent ammoCount = Text.of(gun.getAmmoProvider().getMagazine().map(IMagazine::getSize).orElse(0)).func_240699_a_(TextFormatting.RED);
            IFormattableTextComponent damageText = Text.of(Float.valueOf(this.gunType.getDamage())).func_240699_a_(TextFormatting.RED);
            IFormattableTextComponent headshotDamageText = Text.of((int)(this.gunType.getDamage() * 4.0f)).func_240699_a_(TextFormatting.RED);
            IFormattableTextComponent accuracyText = Text.of((int)((double)this.gunType.getAccuracyPct() * 100.0) + "%").func_240699_a_(TextFormatting.RED);
            IFormattableTextComponent rpmText = Text.of(this.gunType.getFireRateRPM()).func_240699_a_(TextFormatting.RED);
            IFormattableTextComponent rangeText = Text.of(this.gunType.getRange() + " blocks").func_240699_a_(TextFormatting.RED);
            lines.add((ITextComponent)Text.translate("item_lore.gun_item.ammo_amount", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)ammoCount));
            lines.add((ITextComponent)Text.translate("item_lore.gun_item.damage", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)damageText));
            lines.add((ITextComponent)Text.translate("item_lore.gun_item.headshot_damage", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)headshotDamageText));
            if (this.gunType.getBulletAmountToFire() > 1) {
                IFormattableTextComponent pelletsText = Text.of(this.gunType.getBulletAmountToFire()).func_240699_a_(TextFormatting.RED);
                lines.add((ITextComponent)Text.translate("item_lore.gun_item.pellets_shot", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)pelletsText));
            }
            for (AttachmentItem attachment : gun.getAttachments()) {
                IFormattableTextComponent attachmentNameText = attachment.func_200296_o().func_230531_f_().func_240699_a_(TextFormatting.RED);
                lines.add((ITextComponent)Text.translate("item_lore.gun_item.attachment", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)attachmentNameText));
            }
            lines.add((ITextComponent)Text.translate("item_lore.gun_item.rpm", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)rpmText));
            lines.add((ITextComponent)Text.translate("item_lore.gun_item.accuracy", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)accuracyText));
            lines.add((ITextComponent)Text.translate("item_lore.gun_item.range", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)rangeText));
        });
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185311_w || enchantment == Enchantments.field_185309_u || enchantment == Enchantments.field_185307_s || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int func_77619_b() {
        return 1;
    }

    public int func_230305_d_() {
        return 0;
    }

    public static class Properties
    extends Item.Properties {
        private AbstractGunType<?> gunType;
        private Supplier<DistExecutor.SafeCallable<GunRenderer>> rendererFactory;

        public Properties setGunType(AbstractGunType<?> gunType) {
            this.gunType = gunType;
            return this;
        }

        public Properties setRendererFactory(Supplier<DistExecutor.SafeCallable<GunRenderer>> rendererFactory) {
            this.rendererFactory = rendererFactory;
            return this;
        }
    }
}

