/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.capability.SimpleCapabilityProvider;
import com.craftingdead.core.hat.DefaultHat;
import com.craftingdead.core.util.Text;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class HatItem
extends Item {
    private final float headshotReductionPercentage;
    private final boolean immuneToFlashes;
    private final boolean immuneToGas;
    private final boolean nightVision;

    public HatItem(Properties properties) {
        super((Item.Properties)properties);
        this.headshotReductionPercentage = properties.headshotReductionPercentage;
        this.immuneToFlashes = properties.immuneToFlashes;
        this.immuneToGas = properties.immuneToGas;
        this.nightVision = properties.nightVision;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> lore, ITooltipFlag tooltipFlag) {
        if (this.headshotReductionPercentage > 0.0f) {
            IFormattableTextComponent percentageText = Text.of(String.format("%.1f", Float.valueOf(this.headshotReductionPercentage)) + "%").func_240699_a_(TextFormatting.RED);
            lore.add((ITextComponent)Text.translate("item_lore.hat_item.headshot_reduction", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)percentageText));
        }
        if (this.immuneToFlashes) {
            lore.add((ITextComponent)Text.translate("item_lore.hat_item.immune_to_flashes", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        }
        if (this.immuneToGas) {
            lore.add((ITextComponent)Text.translate("item_lore.hat_item.immune_to_gas", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        }
        if (this.nightVision) {
            lore.add((ITextComponent)Text.translate("item_lore.hat_item.has_night_vision", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundNBT nbt) {
        return new SimpleCapabilityProvider(LazyOptional.of(() -> new DefaultHat(this.nightVision, this.headshotReductionPercentage, this.immuneToFlashes)), () -> ModCapabilities.HAT);
    }

    public static class Properties
    extends Item.Properties {
        private float headshotReductionPercentage;
        private boolean immuneToFlashes;
        private boolean immuneToGas;
        private boolean nightVision;

        public Properties setHeadshotReductionPercentage(float headshotReductionPercentage) {
            this.headshotReductionPercentage = headshotReductionPercentage;
            return this;
        }

        public Properties setNightVision(boolean nightVision) {
            this.nightVision = nightVision;
            return this;
        }

        public Properties setImmuneToFlashes(boolean immuneToFlashes) {
            this.immuneToFlashes = immuneToFlashes;
            return this;
        }

        public Properties setImmuneToGas(boolean immuneToGas) {
            this.immuneToGas = immuneToGas;
            return this;
        }
    }
}

