/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.capability.SerializableCapabilityProvider;
import com.craftingdead.core.item.gun.magazine.IMagazine;
import com.craftingdead.core.item.gun.magazine.MagazineImpl;
import com.craftingdead.core.util.Text;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class MagazineItem
extends Item {
    private final float armorPenetration;
    private final int size;
    private final Supplier<? extends Item> nextTier;
    private final boolean customTexture;

    public MagazineItem(Properties properties) {
        super((Item.Properties)properties);
        this.size = properties.size;
        this.armorPenetration = properties.armorPenetration;
        this.nextTier = properties.nextTier;
        this.customTexture = properties.customTexture;
    }

    public float getArmorPenetration() {
        return this.armorPenetration;
    }

    public int getSize() {
        return this.size;
    }

    public Supplier<? extends Item> getNextTier() {
        return this.nextTier;
    }

    public boolean hasCustomTexture() {
        return this.customTexture;
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundNBT nbt) {
        return new SerializableCapabilityProvider(LazyOptional.of(() -> new MagazineImpl(this)), () -> ModCapabilities.MAGAZINE, CompoundNBT::new);
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack materialStack) {
        return Tags.Items.GUNPOWDER.func_230235_a_((Object)materialStack.func_77973_b()) || super.func_82789_a(itemStack, materialStack);
    }

    public int getMaxDamage(ItemStack itemStack) {
        return this.size;
    }

    public int getDamage(ItemStack itemStack) {
        return this.size - itemStack.getCapability(ModCapabilities.MAGAZINE).map(IMagazine::getSize).orElse(this.size);
    }

    public void setDamage(ItemStack itemStack, int damage) {
        itemStack.getCapability(ModCapabilities.MAGAZINE).ifPresent(magazine -> magazine.setSize(Math.max(0, this.size - damage)));
    }

    public boolean func_77645_m() {
        return true;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, lines, tooltipFlag);
        if (this.getSize() > 1) {
            int currentAmount = stack.getCapability(ModCapabilities.MAGAZINE).map(IMagazine::getSize).orElse(0);
            IFormattableTextComponent amountText = Text.of(currentAmount + "/" + this.getSize()).func_240699_a_(TextFormatting.RED);
            lines.add((ITextComponent)Text.translate("item_lore.magazine_item.amount", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)amountText));
        }
        if (this.armorPenetration > 0.0f) {
            lines.add((ITextComponent)Text.translate("item_lore.magazine_item.armor_penetration", new Object[0]).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.of(String.format("%.0f%%", Float.valueOf(this.armorPenetration))).func_240699_a_(TextFormatting.RED)));
        }
    }

    public CompoundNBT getShareTag(ItemStack itemStack) {
        CompoundNBT magazineNbt;
        CompoundNBT nbt = super.getShareTag(itemStack);
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        if ((magazineNbt = (CompoundNBT)itemStack.getCapability(ModCapabilities.MAGAZINE).map(INBTSerializable::serializeNBT).orElse(null)) != null && !magazineNbt.isEmpty()) {
            nbt.func_218657_a("magazine", (INBT)magazineNbt);
        }
        return nbt;
    }

    public void readShareTag(ItemStack itemStack, @Nullable CompoundNBT nbt) {
        super.readShareTag(itemStack, nbt);
        if (nbt != null && nbt.func_150297_b("magazine", 10)) {
            itemStack.getCapability(ModCapabilities.MAGAZINE).ifPresent(magazine -> magazine.deserializeNBT((INBT)nbt.func_74775_l("magazine")));
        }
    }

    public static class Properties
    extends Item.Properties {
        private float armorPenetration;
        private int size;
        private Supplier<? extends Item> nextTier = () -> Items.field_190931_a;
        private boolean customTexture;

        public Properties setArmorPenetration(float armorPenetration) {
            this.armorPenetration = armorPenetration;
            return this;
        }

        public Properties setSize(int size) {
            this.size = size;
            return this;
        }

        public Properties setNextTier(Supplier<? extends Item> nextTier) {
            this.nextTier = nextTier;
            return this;
        }

        public Properties setCustomTexture(boolean customTexture) {
            this.customTexture = customTexture;
            return this;
        }
    }
}

