/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.capability.SerializableCapabilityProvider;
import com.craftingdead.core.item.gun.paint.DefaultPaint;
import com.craftingdead.core.item.gun.paint.IPaint;
import com.craftingdead.core.util.Text;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PaintItem
extends Item {
    private final Optional<Supplier<Integer>> colour;
    private final boolean hasSkin;

    public PaintItem(Properties properties) {
        super((Item.Properties)properties);
        this.colour = Optional.ofNullable(properties.colour);
        this.hasSkin = properties.hasSkin;
    }

    public boolean hasSkin() {
        return this.hasSkin;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> lines, ITooltipFlag tooltipFlag) {
        stack.getCapability(ModCapabilities.PAINT).map(IPaint::getColour).orElse(Optional.empty()).ifPresent(colour -> lines.add((ITextComponent)Text.of("#" + Integer.toHexString(colour)).func_240699_a_(TextFormatting.GRAY)));
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundNBT nbt) {
        return new SerializableCapabilityProvider(LazyOptional.of(() -> new DefaultPaint(this.hasSkin ? this.getRegistryName() : null, this.colour.map(Supplier::get).orElse(null))), () -> ModCapabilities.PAINT, CompoundNBT::new);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = super.getShareTag(stack);
        CompoundNBT paintNbt = stack.getCapability(ModCapabilities.PAINT).map(INBTSerializable::serializeNBT).orElse(null);
        if (paintNbt != null) {
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            nbt.func_218657_a("paint", (INBT)paintNbt);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.func_150297_b("paint", 10)) {
            stack.getCapability(ModCapabilities.PAINT).ifPresent(paint -> paint.deserializeNBT((INBT)nbt.func_74775_l("paint")));
        }
    }

    public static class Properties
    extends Item.Properties {
        private Supplier<Integer> colour;
        private boolean hasSkin = true;

        public Properties setColour() {
            this.colour = () -> new Random().nextInt(0x1000000);
            return this;
        }

        public Properties setColour(Supplier<Integer> colour) {
            this.colour = colour;
            return this;
        }

        public Properties setHasSkin(boolean hasSkin) {
            this.hasSkin = hasSkin;
            return this;
        }
    }
}

