/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item;

import com.craftingdead.core.capability.ModCapabilities;
import com.craftingdead.core.capability.SerializableCapabilityProvider;
import com.craftingdead.core.inventory.InventorySlotType;
import com.craftingdead.core.inventory.container.GenericContainer;
import com.craftingdead.core.storage.DefaultStorage;
import com.craftingdead.core.storage.IStorage;
import com.craftingdead.core.util.Text;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;

public class StorageItem
extends Item {
    public static final int MAX_ROWS_TO_SHOW = 6;
    public static final Supplier<IStorage> VEST = () -> new DefaultStorage(18, InventorySlotType.VEST, GenericContainer::createVest);
    private final NonNullSupplier<IStorage> storageContainer;

    public StorageItem(NonNullSupplier<IStorage> storageContainer, Item.Properties properties) {
        super(properties);
        this.storageContainer = storageContainer;
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundNBT nbt) {
        return new SerializableCapabilityProvider(LazyOptional.of(this.storageContainer), ImmutableSet.of(() -> ModCapabilities.STORAGE, () -> CapabilityItemHandler.ITEM_HANDLER_CAPABILITY), CompoundNBT::new);
    }

    public void func_77624_a(ItemStack backpackStack, World world, List<ITextComponent> lines, ITooltipFlag tooltipFlag) {
        super.func_77624_a(backpackStack, world, lines, tooltipFlag);
        backpackStack.getCapability(ModCapabilities.STORAGE).ifPresent(storage -> {
            if (!storage.isEmpty()) {
                lines.add((ITextComponent)Text.of(" "));
                lines.add((ITextComponent)Text.translate("container.inventory", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}));
                int rowsBeyondLimit = 0;
                for (int i = 0; i < storage.getSlots(); ++i) {
                    ItemStack stack = storage.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    if (i >= 6) {
                        ++rowsBeyondLimit;
                        continue;
                    }
                    IFormattableTextComponent amountText = Text.of(stack.func_190916_E() + "x ").func_240699_a_(TextFormatting.DARK_GRAY);
                    IFormattableTextComponent itemText = stack.func_200301_q().func_230531_f_().func_240699_a_(TextFormatting.GRAY);
                    lines.add((ITextComponent)amountText.func_230529_a_((ITextComponent)itemText));
                }
                if (rowsBeyondLimit > 0) {
                    lines.add((ITextComponent)Text.of(". . . +" + rowsBeyondLimit).func_240699_a_(TextFormatting.RED));
                }
            }
        });
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT storageTag;
        CompoundNBT shareTag = stack.func_77978_p();
        if (shareTag == null) {
            shareTag = new CompoundNBT();
        }
        if ((storageTag = (CompoundNBT)stack.getCapability(ModCapabilities.STORAGE).map(INBTSerializable::serializeNBT).orElse(null)) != null && !storageTag.isEmpty()) {
            shareTag.func_218657_a("storage", (INBT)storageTag);
        }
        return shareTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_150297_b("storage", 10)) {
            stack.getCapability(ModCapabilities.STORAGE).ifPresent(gun -> gun.deserializeNBT((INBT)nbt.func_74775_l("storage")));
        }
        super.readShareTag(stack, nbt);
    }
}

