/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.item.animation.gun;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;

public abstract class GunAnimation {
    public static final String BODY = "body";
    public static final String LEFT_HAND = "left_hand";
    public static final String RIGHT_HAND = "right_hand";
    public static final String MAGAZINE = "magazine";

    public abstract void onUpdate(Minecraft var1, LivingEntity var2, ItemStack var3, float var4);

    public abstract void doRender(ItemStack var1, float var2, MatrixStack var3);

    public abstract void doRenderHand(ItemStack var1, float var2, boolean var3, MatrixStack var4);

    public void doRenderAmmo(ItemStack itemStack, float partialTicks, MatrixStack matrixStack) {
    }

    public boolean renderHand(boolean par1) {
        return true;
    }

    public abstract void onAnimationStopped(ItemStack var1);

    protected abstract float getMaxAnimationTick();

    protected boolean isAcceptedTransformType(ItemCameraTransforms.TransformType transformType) {
        return true;
    }

    protected void applyTransforms(LivingEntity livingEntity, ItemStack itemStack, String part, MatrixStack matrixStack, float partialTicks) {
        switch (part) {
            case "body": {
                this.doRender(itemStack, partialTicks, matrixStack);
                break;
            }
            case "left_hand": {
                this.doRenderHand(itemStack, partialTicks, false, matrixStack);
                break;
            }
            case "right_hand": {
                this.doRenderHand(itemStack, partialTicks, true, matrixStack);
                break;
            }
            case "magazine": {
                this.doRenderAmmo(itemStack, partialTicks, matrixStack);
                break;
            }
        }
    }
}

